/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.IconHelper;

public class WhatsThis {
    private static EventHandler listener = new EventHandler();
    private static HashMap<Component, Cursor> cursorsByComponent = new HashMap();
    private static boolean justEntered;
    private static Cursor gotHelpCursor;
    private static Cursor noHelpCursor;

    static {
        gotHelpCursor = Toolkit.getDefaultToolkit().createCustomCursor(((ImageIcon)IconHelper.getIcon("idea.png", 16)).getImage(), new Point(0, 0), "gotHelpCursor");
        noHelpCursor = Toolkit.getDefaultToolkit().createCustomCursor(((ImageIcon)IconHelper.getIcon("contexthelp.png", 16)).getImage(), new Point(0, 0), "noHelpCursor");
    }

    public static void setText(JComponent c, String text) {
        c.putClientProperty("LongDescription", text);
    }

    public static void removeText(JComponent c) {
        c.putClientProperty("LongDescription", null);
    }

    public static String getText(Component c, boolean searchParents) {
        AbstractButton button;
        String text = null;
        if (c instanceof AbstractButton && (button = (AbstractButton)c).getAction() != null) {
            text = (String)button.getAction().getValue("LongDescription");
        }
        if (text == null && c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            text = (String)jc.getClientProperty("LongDescription");
        }
        if (text == null && searchParents && c.getParent() != null) {
            return WhatsThis.getText(c.getParent(), searchParents);
        }
        return text;
    }

    public static void enterWhatsThisMode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                justEntered = true;
                Toolkit.getDefaultToolkit().addAWTEventListener(listener, 24L);
            }
        });
    }

    public static void exitWhatsThisMode() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        Set<Map.Entry<Component, Cursor>> pairs = cursorsByComponent.entrySet();
        for (Map.Entry<Component, Cursor> entry : pairs) {
            entry.getKey().setCursor(entry.getValue());
        }
        cursorsByComponent.clear();
    }

    private static class WhatsThisPopup
    extends JPopupMenu {
        public WhatsThisPopup(String text) {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            JToolTip tip = new JToolTip();
            this.add(tip);
            tip.setTipText(GUIHelper.tt(text, 200));
        }
    }

    private static class EventHandler
    implements AWTEventListener {
        EventHandler() {
        }

        public void eventDispatched(AWTEvent event) {
            switch (event.getID()) {
                case 503: {
                    if (justEntered) {
                        justEntered = false;
                        this.entered((MouseEvent)event);
                    }
                }
                case 504: {
                    this.entered((MouseEvent)event);
                    break;
                }
                case 505: {
                    this.exited((MouseEvent)event);
                    break;
                }
                case 500: {
                    ((MouseEvent)event).consume();
                    break;
                }
                case 501: {
                    this.showPopup((MouseEvent)event);
                    break;
                }
                case 502: {
                    ((MouseEvent)event).consume();
                    break;
                }
                case 401: {
                    this.keyPressed((KeyEvent)event);
                }
            }
        }

        private void showPopup(MouseEvent e) {
            Component c;
            String whatsThisText;
            e.consume();
            if (e.getSource() instanceof Component && (whatsThisText = WhatsThis.getText(c = (Component)e.getSource(), true)) != null) {
                WhatsThisPopup popup = new WhatsThisPopup(whatsThisText);
                popup.show(c, e.getX(), e.getY());
            }
            this.exited(e);
            WhatsThis.exitWhatsThisMode();
        }

        private void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                WhatsThis.exitWhatsThisMode();
                e.consume();
            }
        }

        private void entered(MouseEvent e) {
            if (e.getSource() instanceof Component) {
                String whatsThisText;
                Component c = (Component)e.getSource();
                if (c.isCursorSet()) {
                    cursorsByComponent.containsKey(c);
                    cursorsByComponent.put(c, c.getCursor());
                }
                if ((whatsThisText = WhatsThis.getText(c, true)) != null) {
                    c.setCursor(gotHelpCursor);
                } else {
                    c.setCursor(noHelpCursor);
                }
            }
        }

        private void exited(MouseEvent e) {
            if (e.getSource() instanceof Component) {
                ((Component)e.getSource()).setCursor((Cursor)cursorsByComponent.get(e.getSource()));
            }
        }
    }
}

