/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconHelper {
    public static final String DEFAULT_ICON_PATH = "icons/";
    public static ClassLoader classLoader = IconHelper.class.getClassLoader();
    private static final int[] DEFAULT_ICON_SUBDIRECTORIES = new int[]{64, 52, 32, 22, 16};
    private static String iconPath = "icons/";
    private static int[] subDirectories = DEFAULT_ICON_SUBDIRECTORIES;
    static /* synthetic */ Class class$0;

    public static final Icon getIcon(String filename, int size, boolean createEmptyIcon) {
        if (filename == null) {
            return createEmptyIcon ? new EmptyIcon(size) : null;
        }
        ImageIcon icon = IconHelper.getImage(size, filename);
        if (icon != null) {
            if (icon.getIconWidth() != size || icon.getIconHeight() != size) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(size, size, 4));
            }
            return icon;
        }
        return createEmptyIcon ? new EmptyIcon(size) : null;
    }

    public static final Icon getIcon(String filename, int size) {
        return IconHelper.getIcon(filename, size, true);
    }

    public static final ImageIcon getImage(String filename) {
        URL url = classLoader.getResource(String.valueOf(iconPath) + filename);
        return url != null ? IconHelper.getImageIcon(url) : null;
    }

    public static final ImageIcon getImage(int size, String filename) {
        URL url = classLoader.getResource(DEFAULT_ICON_PATH + size + "/" + filename);
        if (url != null) {
            return IconHelper.getImageIcon(url);
        }
        int i = 0;
        while (i < subDirectories.length) {
            if (subDirectories[i] != size && (url = classLoader.getResource(DEFAULT_ICON_PATH + subDirectories[i] + "/" + filename)) != null) {
                return IconHelper.getImageIcon(url);
            }
            ++i;
        }
        return null;
    }

    public static final ImageIcon getImageIcon(URL url) {
        return new ImageIcon(url);
    }

    public static final Icon getEmptyIcon(int size) {
        return new EmptyIcon(size);
    }

    public static final Icon getListIcon(String filename) {
        return IconHelper.getIcon(filename, 32, false);
    }

    public static final Icon getButtonIcon(String filename) {
        return IconHelper.getIcon(filename, 16, false);
    }

    public static final Icon getMenuIcon(String filename) {
        return IconHelper.getIcon(filename, 16);
    }

    public static final Icon getStatusBarIcon(String filename) {
        return IconHelper.getIcon(filename, 16, false);
    }

    public static final Icon getTableIcon(String filename) {
        return IconHelper.getIcon(filename, 14, true);
    }

    public static final Icon getTabTitleIcon(String filename) {
        return IconHelper.getIcon(filename, 16, false);
    }

    public static final Icon getTreeIcon(String filename) {
        return IconHelper.getIcon(filename, 16, false);
    }

    public static final Icon getToolBarIcon(String filename) {
        return IconHelper.getIcon(filename, 22);
    }

    public static final Icon getTitleIcon(String filename) {
        return IconHelper.getIcon(filename, 32, false);
    }

    public static void setIconPath(String iconPath) {
        IconHelper.iconPath = iconPath;
    }

    public static void setSubDirectories(int[] subDirectories) {
        IconHelper.subDirectories = subDirectories;
    }

    public static Icon getActionIcon(String filename) {
        return IconHelper.getIcon(filename, 16, false);
    }

    public static class EmptyIcon
    implements Icon {
        private int size;

        public EmptyIcon(int size) {
            this.size = size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

