/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xnap.commons.gui.ThinBevelBorder;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.util.FileHelper;
import org.xnap.commons.util.SystemHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIHelper {
    static final I18n I18N = I18nFactory.getI18n(GUIHelper.class);
    public static final int POPUP_MENU_HEIGHT_INSET = 50;
    static /* synthetic */ Class class$0;

    public static boolean bindEnterKey(JComponent c, Action action) {
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        return GUIHelper.bindKey(c, ks, action, true);
    }

    public static boolean bindEnterKeyLocally(JComponent c, Action action) {
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        return GUIHelper.bindKey(c, ks, action, false);
    }

    public static boolean bindEscapeKey(JComponent c, Action action) {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        return GUIHelper.bindKey(c, ks, action, true);
    }

    public static boolean bindKey(JComponent c, KeyStroke ks, Action action, boolean whenInFocusedWindow) {
        InputMap inputMap = whenInFocusedWindow ? c.getInputMap(2) : c.getInputMap();
        ActionMap actionMap = c.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(ks, action);
            actionMap.put(action, action);
            return true;
        }
        return false;
    }

    public static Border createDefaultBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " " + title + " ");
    }

    public static Border createEmptyBorder(int inset) {
        return BorderFactory.createEmptyBorder(inset, inset, inset, inset);
    }

    public static Border createEmptyBorder() {
        return GUIHelper.createEmptyBorder(0);
    }

    public static Border createEtchedBorder() {
        return BorderFactory.createEtchedBorder();
    }

    public static Border createLoweredBorder() {
        return new ThinBevelBorder(1);
    }

    public static Border createRaisedBorder() {
        return new ThinBevelBorder(0);
    }

    public static JComponent createHeader(String title) {
        Color foreground;
        JLabel label = new JLabel(title);
        Font font = UIManager.getFont("TitledBorder.font");
        if (font != null) {
            label.setFont(font.deriveFont(1));
        }
        if ((foreground = UIManager.getColor("TitledBorder.titleColor")) != null) {
            label.setForeground(foreground);
        }
        return label;
    }

    public static Border createTitledBorder(String title, int inset) {
        return BorderFactory.createCompoundBorder(GUIHelper.createDefaultBorder(title), GUIHelper.createEmptyBorder(inset));
    }

    public static void expandAllNodes(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        GUIHelper.expandAllNodes(tree, new TreePath(root), expand);
    }

    public static void expandAllNodes(JTree tree, TreePath path, boolean expand) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                TreePath childPath = path.pathByAddingChild(child);
                GUIHelper.expandAllNodes(tree, childPath, expand);
            }
        }
        if (expand) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    public static void restrictWidth(JComponent jc) {
        jc.setMaximumSize(new Dimension(jc.getPreferredSize().width, jc.getMaximumSize().height));
    }

    public static void scrollToEnd(JTextComponent jt) {
        jt.setCaretPosition(jt.getDocument().getEndPosition().getOffset() - 1);
    }

    public static boolean shouldScroll(JScrollBar jsb) {
        int pos = jsb.getValue() + jsb.getVisibleAmount();
        return pos == jsb.getMaximum();
    }

    public static KeyStroke getMenuKeyStroke(int keyCode) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(keyCode, mask);
    }

    public static void setAccelerator(JMenuItem jmi, int keyCode) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jmi.setAccelerator(KeyStroke.getKeyStroke(keyCode, mask));
    }

    public static void setMnemonics(JTabbedPane pane) {
        HashSet<Integer> letters = new HashSet<Integer>();
        int i = 0;
        while (i < pane.getTabCount()) {
            if (pane.getMnemonicAt(i) == 0) {
                pane.setMnemonicAt(i, GUIHelper.getMnemonicForText(pane.getTitleAt(i), letters));
            }
            ++i;
        }
    }

    public static void setMnemonics(Container c) {
        GUIHelper.setMnemonics(c, null);
    }

    public static void setMnemonics(Container c, HashSet<Integer> l) {
        HashSet<Integer> letters = l != null ? l : new HashSet<Integer>();
        int i = 0;
        while (i < c.getComponentCount()) {
            Component component = c.getComponent(i);
            if (component instanceof AbstractButton) {
                AbstractButton ab = (AbstractButton)component;
                if (ab.getMnemonic() == 0) {
                    GUIHelper.setMnemonics(ab, letters);
                } else {
                    letters.add(new Integer(ab.getMnemonic()));
                }
            }
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                if (label.getDisplayedMnemonic() != 0) {
                    letters.add(new Integer(label.getDisplayedMnemonic()));
                }
                if (label.getLabelFor() != null) {
                    GUIHelper.setMnemonics(label, letters);
                }
            }
            if (component instanceof JMenu) {
                GUIHelper.setMnemonics(((JMenu)component).getPopupMenu());
            }
            if (component instanceof Container) {
                GUIHelper.setMnemonics((Container)component, letters);
            }
            ++i;
        }
    }

    private static boolean setMnemonics(JLabel label, HashSet<Integer> letters) {
        if (label.getText() == null) {
            return true;
        }
        String text = label.getText();
        StringTokenizer t = new StringTokenizer(text);
        while (t.hasMoreTokens()) {
            char character = t.nextToken().charAt(0);
            if (letters.contains(character)) continue;
            letters.add(Integer.valueOf(character));
            label.setDisplayedMnemonic((int)character);
            return true;
        }
        int i = 1;
        while (i < text.length()) {
            char character = text.charAt(i);
            if (text.charAt(i) != ' ' && !letters.contains(character)) {
                letters.add(Integer.valueOf(character));
                label.setDisplayedMnemonic((int)character);
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getMnemonicForText(String text, HashSet<Integer> letters) {
        StringTokenizer t = new StringTokenizer(text);
        while (t.hasMoreTokens()) {
            char character = t.nextToken().charAt(0);
            if (letters.contains(character)) continue;
            letters.add(Integer.valueOf(character));
            return character;
        }
        int i = 1;
        while (i < text.length()) {
            char character = text.charAt(i);
            if (text.charAt(i) != ' ' && !letters.contains(character)) {
                letters.add(Integer.valueOf(character));
                return character;
            }
            ++i;
        }
        return 0;
    }

    private static boolean setMnemonics(AbstractButton ab, HashSet<Integer> letters) {
        if (ab.getText() == null) {
            return true;
        }
        String text = ab.getText().toUpperCase();
        StringTokenizer t = new StringTokenizer(text);
        while (t.hasMoreTokens()) {
            char character = t.nextToken().charAt(0);
            if (letters.contains(character)) continue;
            letters.add(Integer.valueOf(character));
            ab.setMnemonic((int)character);
            return true;
        }
        int i = 1;
        while (i < text.length()) {
            char character = text.charAt(i);
            if (text.charAt(i) != ' ' && !letters.contains(character)) {
                letters.add(Integer.valueOf(character));
                ab.setMnemonic((int)character);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showFile(JTextComponent jtc, String filename, String altText) {
        InputStream s = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (s != null) {
            try {
                jtc.setText(FileHelper.readText(s));
                jtc.setCaretPosition(0);
                return;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        jtc.setText(altText);
    }

    public static void showPopupMenu(JPopupMenu jpm, Component source, int x, int y, int yOffset) {
        int width;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        screen.height -= 50;
        Point origin = source.getLocationOnScreen();
        origin.translate(x, y);
        int height = jpm.getHeight();
        if (height == 0) {
            jpm.addComponentListener(new SizeListener(source, x, y));
        }
        if (origin.x + (width = jpm.getWidth()) > screen.width) {
            x -= width;
        }
        if (origin.y + height > screen.height) {
            y -= height;
            y += yOffset;
        }
        jpm.show(source, x, y);
    }

    public static void showPopupMenu(JPopupMenu jpm, Component source, int x, int y) {
        GUIHelper.showPopupMenu(jpm, source, x, y, 0);
    }

    public static String label(String text) {
        return GUIHelper.tt(text, 500);
    }

    public static String tt(String text, int width) {
        StringBuilder sb = new StringBuilder(33 + text.length() + 25);
        sb.append("<html>");
        sb.append("<table><tr><td width=\"" + width + "\">");
        if (SystemHelper.IS_JDK13_OR_SMALLER) {
            sb.append("<font face=\"sansserif,arial,helvetica,tahoma\">");
        }
        sb.append(text);
        if (SystemHelper.IS_JDK13_OR_SMALLER) {
            sb.append("</font>");
        }
        sb.append("</td></tr></table>");
        sb.append("</html>");
        return sb.toString();
    }

    public static KeyStroke getMenuShortcut(int keyCode) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(keyCode, mask);
    }

    public static String tt(String text) {
        return GUIHelper.tt(text, 300);
    }

    public static String tableRow(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr><td><b>");
        sb.append(key);
        sb.append("</b></td><td> ");
        sb.append(value != null ? value : I18N.tr("Unknown"));
        sb.append("</td></tr>");
        return sb.toString();
    }

    public static void limitSize(JComponent c) {
        c.setMaximumSize(new Dimension(c.getPreferredSize().width, c.getMaximumSize().height));
    }

    public static void bindExpandCollapseKeysToTree(final JTree tree) {
        AbstractAction treeExpandAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    GUIHelper.expandAllNodes(tree, path, true);
                }
            }
        };
        tree.getActionMap().put(treeExpandAction, treeExpandAction);
        tree.getInputMap().put(KeyStroke.getKeyStroke(106, 0), treeExpandAction);
        tree.getInputMap().put(KeyStroke.getKeyStroke(151, 1), treeExpandAction);
        AbstractAction treeCollapseAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    GUIHelper.expandAllNodes(tree, path, false);
                }
            }
        };
        tree.getActionMap().put(treeCollapseAction, treeCollapseAction);
        tree.getInputMap().put(KeyStroke.getKeyStroke(111, 0), treeCollapseAction);
    }

    public static void bindEmacsKeysToTable(JTable jta) {
        ActionListener al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(40, 0));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(78, 2), 0);
        al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(38, 0));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(80, 2), 0);
        al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(86, 2), 0);
        al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(86, 8), 0);
        al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(36, 2));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(153, 8), 0);
        al = jta.getActionForKeyStroke(KeyStroke.getKeyStroke(35, 2));
        jta.registerKeyboardAction(al, KeyStroke.getKeyStroke(153, 9), 0);
    }

    private static class SizeListener
    extends ComponentAdapter {
        private Component source;
        private int x;
        private int y;

        public SizeListener(Component source, int x, int y) {
            this.source = source;
            this.x = x;
            this.y = y;
        }

        public void componentResized(ComponentEvent e) {
            e.getComponent().removeComponentListener(this);
            GUIHelper.showPopupMenu((JPopupMenu)e.getComponent(), this.source, this.x, this.y);
        }
    }
}

