/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;

public class DoubleClickListener
extends MouseAdapter {
    public static final int DOUBLE_CLICK_ID = 0;
    private String actionCommand;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();

    public DoubleClickListener() {
    }

    public DoubleClickListener(ActionListener listener) {
        this.addActionListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void mousePressed(MouseEvent e) {
        Component component = e.getComponent();
        if (e.getClickCount() == 2) {
            ActionListener[] array;
            int row = 0;
            if (component instanceof JTable) {
                row = ((JTable)component).rowAtPoint(e.getPoint());
            } else if (component instanceof JList) {
                row = ((JList)component).locationToIndex(e.getPoint());
            } else if (component instanceof JTree) {
                row = ((JTree)component).getRowForLocation(e.getX(), e.getY());
            }
            if (row != -1 && (array = this.listeners.toArray(new ActionListener[0])).length > 0) {
                ActionEvent event = new ActionEvent(component, 0, this.getActionCommand());
                int i = array.length - 1;
                while (i >= 0) {
                    array[i].actionPerformed(event);
                    --i;
                }
            }
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }
}

