/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIterator
implements Iterator<Component> {
    private LinkedList<Component> stack = new LinkedList();
    private Component lookAhead = null;

    public ComponentIterator(Component component) {
        this.stack.add(component);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.lookAhead == null) {
            this.lookAhead = this.findNext();
        }
        return this.lookAhead != null;
    }

    @Override
    public Component next() {
        if (this.lookAhead == null) {
            this.lookAhead = this.findNext();
            if (this.lookAhead == null) {
                throw new NoSuchElementException();
            }
        }
        Component result = this.lookAhead;
        this.lookAhead = null;
        return result;
    }

    private Component findNext() {
        while (!this.stack.isEmpty()) {
            Component c = this.stack.removeLast();
            if (c instanceof JMenu) {
                c = ((JMenu)c).getPopupMenu();
            } else if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport();
            }
            if (c instanceof JPanel || c instanceof JPopupMenu || c instanceof JViewport) {
                int i = ((Container)c).getComponentCount() - 1;
                while (i >= 0) {
                    Component component = ((Container)c).getComponent(i);
                    this.stack.addLast(component);
                    --i;
                }
                continue;
            }
            return c;
        }
        return null;
    }
}

