/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.tree;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import org.xnap.commons.gui.tree.AbstractTreeModel;
import org.xnap.commons.gui.tree.FileNode;

public class FileTreeModel
extends AbstractTreeModel {
    private List<Object> subRoots;
    private Hashtable<String, List<FileNode>> subChildren = new Hashtable();
    private File cachedDir;
    private boolean cacheSorted;
    private File[] cache;
    private FileComparator comparator;
    private FileFilter filter = new DefaultFilter();
    private boolean sort = true;

    public FileTreeModel(String root, File[] roots) {
        super(root);
        if (roots != null) {
            this.subRoots = new ArrayList<Object>(roots.length);
            int i = 0;
            while (i < roots.length) {
                this.addSubRoot(roots[i]);
                ++i;
            }
        } else {
            this.subRoots = new ArrayList<Object>();
        }
    }

    public FileTreeModel(String root) {
        this(root, null);
    }

    public boolean isLeaf(Object node) {
        return false;
    }

    public int getChildCount(Object node) {
        if (node instanceof File && ((File)node).canRead()) {
            return this.getSubDirs((File)node, false).length;
        }
        if (node instanceof String) {
            if (node.equals(this.root)) {
                return this.subRoots.size();
            }
            return this.subChildren.get(node).size();
        }
        return 0;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, this.sort);
            if (index >= children.length) {
                return null;
            }
            return new FileNode(children[index]);
        }
        if (parent instanceof String) {
            if (parent.equals(this.root) && index < this.subRoots.size()) {
                return this.subRoots.get(index);
            }
            List<FileNode> v = this.subChildren.get(parent);
            return index < v.size() ? v.get(index) : null;
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, this.sort);
            if (children == null) {
                return -1;
            }
            int i = 0;
            while (i < children.length) {
                if (children[i] == child) {
                    return i;
                }
                ++i;
            }
        } else if (parent instanceof String) {
            if (parent.equals(this.root)) {
                return this.subRoots.indexOf(child);
            }
            return this.subChildren.get(parent).indexOf(child);
        }
        return -1;
    }

    private File[] getSubDirs(File f, boolean doSort) {
        if (f == this.cachedDir && this.cacheSorted == doSort) {
            return this.cache;
        }
        File[] children = f.listFiles(this.filter);
        if (children == null) {
            this.cache = new File[0];
        } else {
            this.cache = children;
            if (doSort) {
                Arrays.sort(this.cache, this.getComparator());
            }
        }
        this.cachedDir = f;
        this.cacheSorted = doSort;
        return this.cache;
    }

    public void addSubRoot(String name) {
        if (this.subRoots.contains(name)) {
            return;
        }
        this.subRoots.add(name);
        this.subChildren.put(name, new ArrayList());
        Object[] path = new Object[]{this.root};
        int[] indices = new int[]{this.subRoots.size() - 1};
        Object[] children = new Object[]{name};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, indices, children));
    }

    public void addSubRoot(File f) {
        if (this.subRoots.contains(f)) {
            return;
        }
        this.subRoots.add(f);
        Object[] path = new Object[]{this.root};
        int[] indices = new int[]{this.subRoots.size() - 1};
        Object[] children = new Object[]{f};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, indices, children));
    }

    public void removeSubRoots() {
        int i = 0;
        while (i < this.subRoots.size()) {
            this.subChildren.remove(this.subRoots.get(i));
            ++i;
        }
        this.subRoots.clear();
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    public void removeChildrenOfSubRoot(String s) {
        if (!this.subRoots.contains(s)) {
            return;
        }
        this.subChildren.get(s).clear();
        Object[] path = new Object[]{this.root, s};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    public void addChildOfSubRoot(File file, String subRoot) {
        this.addChildOfSubRoot(file, subRoot, null);
    }

    public void addChildOfSubRoot(File file, String subRoot, String label) {
        this.addSubRoot(subRoot);
        List<FileNode> children = this.subChildren.get(subRoot);
        FileNode node = new FileNode(file, true, label);
        if (children.contains(node)) {
            return;
        }
        children.add(node);
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new Object[]{this.root, subRoot}, new int[]{children.size() - 1}, new Object[]{file}));
    }

    public void removeChildOfSubRoot(File file, String subRoot) {
        FileNode node;
        if (!this.subRoots.contains(subRoot)) {
            return;
        }
        List<FileNode> children = this.subChildren.get(subRoot);
        int index = children.indexOf(node = new FileNode(file, true));
        if (index == -1) {
            return;
        }
        children.remove(index);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root, subRoot}, new int[]{index}, new Object[]{node}));
    }

    private FileComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new FileComparator();
        }
        return this.comparator;
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    public void setSortListedFiles(boolean sort) {
        if (this.sort != sort) {
            this.sort = sort;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }

    public boolean getSortListedFiles() {
        return this.sort;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileComparator
    implements Comparator<File> {
        FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath());
        }
    }

    private class DefaultFilter
    implements FileFilter {
        DefaultFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && !file.isHidden();
        }
    }
}

