/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.text.DateFormat;
import java.util.Date;
import javax.swing.table.DefaultTableCellRenderer;
import org.xnap.commons.util.StringHelper;

public class TimeCellRenderer
extends DefaultTableCellRenderer {
    private DateFormat dateFormat;

    public TimeCellRenderer(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.setHorizontalAlignment(4);
    }

    public TimeCellRenderer() {
        this(DateFormat.getDateInstance());
    }

    protected void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else if (value instanceof Integer) {
            int i = ((Number)value).intValue();
            super.setValue(i >= 0 ? StringHelper.formatLength(i) : null);
        } else if (value instanceof Long) {
            long l = (Long)value;
            super.setValue(l >= 0L ? this.dateFormat.format(new Date(l)) : null);
        } else if (value instanceof Date) {
            super.setValue(this.dateFormat.format((Date)value));
        } else {
            throw new IllegalArgumentException("Expected Integer, Long or java.util.Date; received " + value.getClass());
        }
    }
}

