/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.xnap.commons.gui.table.SortableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSorter
extends AbstractTableModel
implements SortableModel {
    protected int[] indexes = new int[0];
    protected int[] revIndexes = new int[0];
    protected ArrayList<Integer> sortingColumns = new ArrayList();
    protected SortableModel.Order sortOrder = SortableModel.Order.UNSORTED;
    protected int compares;
    protected int lastSortedColumn = -1;
    protected boolean maintainSortOrder;
    private TableModel tableModel;
    private TableModelListener tableModelListener = new TableModelHandler();
    static /* synthetic */ Class class$0;

    public TableSorter() {
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.mapToIndex(row), column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.tableModel.getValueAt(this.mapToIndex(row), column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int row, int column) {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            this.tableModel.setValueAt(aValue, this.mapToIndex(row), column);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getSortedColumn() {
        return this.lastSortedColumn;
    }

    @Override
    public SortableModel.Order getSortOrder() {
        return this.sortOrder;
    }

    public int mapToIndex(int i) {
        return this.indexes[i];
    }

    @Override
    public void setMaintainSortOrder(boolean newValue) {
        this.maintainSortOrder = newValue;
    }

    @Override
    public void setSortOrder(SortableModel.Order newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        this.sortOrder = newValue;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.reallocateIndexes();
        this.fireTableStructureChanged();
    }

    @Override
    public SortableModel.Order sortByColumn(int column, SortableModel.Order sortOrder, boolean revert) {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column is invalid");
        }
        this.sortingColumns.clear();
        this.sortingColumns.add(new Integer(column));
        this.setSortOrder(sortOrder);
        if (!this.sort() && revert) {
            this.setSortOrder(sortOrder.next());
            this.sort();
        }
        this.lastSortedColumn = column;
        return this.getSortOrder();
    }

    public void resort() {
        if (this.lastSortedColumn != -1) {
            this.sortByColumn(this.lastSortedColumn, this.getSortOrder(), false);
        }
    }

    protected int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            int column = this.sortingColumns.get(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.sortOrder == SortableModel.Order.ASCENDING ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    protected int compareRowsByColumn(int row1, int row2, int column) {
        Class<?> type = this.getColumnClass(column);
        Object o1 = this.tableModel.getValueAt(row1, column);
        Object o2 = this.tableModel.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type == String.class) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int result = s1.compareToIgnoreCase(s2);
            if (s1.length() == 0 ^ s2.length() == 0) {
                result = -result;
            }
            return result;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void reallocateIndexes(TableModelEvent e) {
        rowCount = this.getRowCount();
        if (rowCount == this.indexes.length) {
            return;
        }
        newIndexes = new int[rowCount];
        newRevIndexes = new int[rowCount];
        var5_5 = this.indexes;
        synchronized (this.indexes) {
            block15: {
                block14: {
                    row = 0;
                    if (e == null || e.getType() != -1) break block14;
                    skipped = 0;
                    while (row < this.indexes.length) {
                        dec = 0;
                        skip = false;
                        i = e.getFirstRow();
                        while (i <= e.getLastRow()) {
                            if (i < this.indexes[row]) {
                                ++dec;
                            } else if (i == this.indexes[row]) {
                                skip = true;
                            }
                            ++i;
                        }
                        if (skip) {
                            ++skipped;
                        } else {
                            newIndexes[row - skipped] = this.indexes[row] - dec;
                            newRevIndexes[this.indexes[row] - dec] = row - skipped;
                        }
                        ++row;
                    }
                    break block15;
                }
                if (e == null || e.getType() != 0 || e.getLastRow() < this.indexes.length) ** GOTO lbl44
                i = 0;
                while (i < rowCount) {
                    newIndexes[i] = i;
                    newRevIndexes[i] = i;
                    ++i;
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    newIndexes[row] = this.indexes[row];
                    newRevIndexes[row] = this.revIndexes[row];
                    ++row;
lbl44:
                    // 2 sources

                    ** while (row < this.indexes.length && row < rowCount)
                }
lbl45:
                // 2 sources

                while (row < rowCount) {
                    newIndexes[row] = row;
                    newRevIndexes[row] = row;
                    ++row;
                }
            }
            this.indexes = newIndexes;
            this.revIndexes = newRevIndexes;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected void reallocateIndexes() {
        this.reallocateIndexes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sort() {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            block8: {
                block7: {
                    if (this.sortOrder != SortableModel.Order.UNSORTED) break block7;
                    int i = 0;
                    while (i < this.indexes.length) {
                        this.indexes[i] = i;
                        this.revIndexes[i] = i;
                        ++i;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                this.compares = 0;
                int[] oldIndexes = new int[this.indexes.length];
                System.arraycopy(this.indexes, 0, oldIndexes, 0, this.indexes.length);
                if (!this.shuttlesort(oldIndexes, this.indexes, 0, this.indexes.length)) break block8;
                int i = 0;
                while (i < this.indexes.length) {
                    this.revIndexes[this.indexes[i]] = i;
                    ++i;
                }
                this.fireTableChanged(new TableModelEvent(this));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public boolean shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return false;
        }
        boolean changed = false;
        int middle = (low + high) / 2;
        changed |= this.shuttlesort(to, from, low, middle);
        changed |= this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4) {
            if (this.compare(from[middle - 1], from[middle]) <= 0) {
                int i = low;
                while (i < high) {
                    to[i] = from[i];
                    ++i;
                }
                return changed;
            }
            if (this.compare(from[high - 1], from[low]) < 0) {
                int i = low;
                while (q < high) {
                    to[i++] = from[q];
                    ++q;
                }
                while (i < high) {
                    to[i] = from[p++];
                    ++i;
                }
                return changed;
            }
        }
        int i = low;
        while (i < high) {
            if (q >= high || p < middle && this.compare(from[p], from[q]) <= 0) {
                to[i] = from[p++];
            } else {
                changed |= p < middle;
                to[i] = from[q++];
            }
            ++i;
        }
        return changed;
    }

    public boolean getMaintainSortOrder() {
        return this.maintainSortOrder;
    }

    private class TableModelHandler
    implements TableModelListener {
        TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            TableSorter.this.reallocateIndexes(e);
            if (TableSorter.this.maintainSortOrder && TableSorter.this.sort()) {
                return;
            }
            if (e.getType() == -1 || e.getType() == 0 && e.getLastRow() >= TableSorter.this.revIndexes.length) {
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this));
            } else {
                int i = e.getFirstRow();
                while (i <= e.getLastRow()) {
                    TableModelEvent t = new TableModelEvent(TableSorter.this, TableSorter.this.revIndexes[i], TableSorter.this.revIndexes[i], e.getColumn(), e.getType());
                    TableSorter.this.fireTableChanged(t);
                    ++i;
                }
            }
        }
    }
}

