/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.SettingStore;

public class TableLayoutManager {
    private List<ColumnProperties> columnProperties = new ArrayList<ColumnProperties>();
    private int currentIndex = 0;
    private List<String> defaultColumns = new ArrayList<String>();
    private ResetTableLayoutAction resetTableLayoutAction;
    private TableLayout tableLayout;

    public TableLayoutManager(JTable table) {
        this.tableLayout = new TableLayout(table);
        this.resetTableLayoutAction = new ResetTableLayoutAction();
        this.tableLayout.getHeaderPopupMenu().add(new JMenuItem(this.resetTableLayoutAction));
    }

    public void addColumnProperties(String key, String name, int width, boolean defaultColumn) {
        ColumnProperties props = new ColumnProperties();
        props.index = this.currentIndex;
        props.key = key;
        props.name = name;
        props.width = width;
        if (defaultColumn) {
            this.defaultColumns.add(key);
        }
        this.columnProperties.add(props);
        ++this.currentIndex;
    }

    private String[] getDefaultColumns() {
        return this.defaultColumns.toArray(new String[0]);
    }

    public ResetTableLayoutAction getResetTableLayoutAction() {
        return this.resetTableLayoutAction;
    }

    public TableLayout getTableLayout() {
        return this.tableLayout;
    }

    public void initializeTableLayout() {
        for (ColumnProperties props : this.columnProperties) {
            this.getTableLayout().setColumnProperties(props.index, props.key, props.width);
            this.getTableLayout().setColumnName(props.index, props.name);
        }
    }

    public void resetTableLayout() {
        for (ColumnProperties props : this.columnProperties) {
            this.getTableLayout().setColumnProperties(props.index, props.key, props.width);
        }
        this.getTableLayout().setColumnsVisible(this.getDefaultColumns());
        this.getTableLayout().getTable().getTableHeader().revalidate();
    }

    public void restoreLayout(SettingStore store, String key) {
        store.restoreTable(key, this.getDefaultColumns(), this.getTableLayout());
    }

    public void saveLayout(SettingStore store, String key) {
        store.saveTable(key, this.getTableLayout());
    }

    private static class ColumnProperties {
        boolean defaultColumn;
        int index;
        String key;
        public String name;
        int width;

        ColumnProperties() {
        }
    }

    private class ResetTableLayoutAction
    extends AbstractXNapAction {
        static /* synthetic */ Class class$0;

        public ResetTableLayoutAction() {
            this.putValue("Name", I18nFactory.getI18n(TableLayoutManager.class).tr("Reset Columns"));
        }

        public void actionPerformed(ActionEvent event) {
            TableLayoutManager.this.resetTableLayout();
        }
    }
}

