/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.xnap.commons.gui.table.SortableModel;
import org.xnap.commons.gui.table.TableHeaderMenu;
import org.xnap.commons.gui.table.TableLayoutListener;
import org.xnap.commons.gui.table.TableSorter;
import org.xnap.commons.gui.util.GUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLayout {
    private List<TableColumn> columns;
    private EventHandler eventHandler;
    private Enumeration expandedLeafs;
    private JTableHeader header;
    private JPopupMenu headerPopupMenu;
    private List<TableLayoutListener> listeners = new ArrayList<TableLayoutListener>();
    private SortButtonRenderer renderer;
    private TreePath[] selectedPaths;
    private TableSorter sorter;
    private boolean sorting = false;
    private JTable table;
    private JTree tree;
    static /* synthetic */ Class class$0;

    public TableLayout(JTable table) {
        this(table, (TableSorter)table.getModel());
    }

    public TableLayout(JTable table, TableSorter sorter) {
        this.table = table;
        this.header = table.getTableHeader();
        this.sorter = sorter;
        this.eventHandler = new EventHandler();
        TableColumnModel columnModel = table.getColumnModel();
        this.columns = new ArrayList<TableColumn>(columnModel.getColumnCount());
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            this.addColumn(columnModel.getColumn(i));
            ++i;
        }
        columnModel.addColumnModelListener(this.eventHandler);
        this.headerPopupMenu = new TableHeaderMenu(null, this).getPopupMenu();
        this.renderer = new SortButtonRenderer(this.header.getDefaultRenderer());
        this.header.setDefaultRenderer(this.renderer);
        this.header.setReorderingAllowed(true);
        this.header.setResizingAllowed(true);
        this.header.addMouseListener(this.eventHandler);
        this.header.addMouseMotionListener(this.eventHandler);
    }

    private void addColumn(TableColumn column) {
        column.addPropertyChangeListener(this.eventHandler);
        this.columns.add(column);
    }

    public void addTableLayoutListener(TableLayoutListener l) {
        this.listeners.add(l);
    }

    private void fireColumnNameChanged(int index, String newName) {
        TableLayoutListener[] array;
        TableLayoutListener[] tableLayoutListenerArray = array = this.listeners.toArray(new TableLayoutListener[0]);
        int n = 0;
        int n2 = tableLayoutListenerArray.length;
        while (n < n2) {
            TableLayoutListener listener = tableLayoutListenerArray[n];
            listener.columnNameChanged(index, newName);
            ++n;
        }
    }

    private void fireColumnOrderChanged() {
        TableLayoutListener[] array;
        TableLayoutListener[] tableLayoutListenerArray = array = this.listeners.toArray(new TableLayoutListener[0]);
        int n = 0;
        int n2 = tableLayoutListenerArray.length;
        while (n < n2) {
            TableLayoutListener listener = tableLayoutListenerArray[n];
            listener.columnOrderChanged();
            ++n;
        }
    }

    private void fireColumnVisibilityChanged(int index, boolean visible) {
        TableLayoutListener[] array;
        TableLayoutListener[] tableLayoutListenerArray = array = this.listeners.toArray(new TableLayoutListener[0]);
        int n = 0;
        int n2 = tableLayoutListenerArray.length;
        while (n < n2) {
            TableLayoutListener listener = tableLayoutListenerArray[n];
            listener.columnVisibilityChanged(index, visible);
            ++n;
        }
    }

    private void fireColumnWidthsChanged() {
        TableLayoutListener[] array;
        TableLayoutListener[] tableLayoutListenerArray = array = this.listeners.toArray(new TableLayoutListener[0]);
        int n = 0;
        int n2 = tableLayoutListenerArray.length;
        while (n < n2) {
            TableLayoutListener listener = tableLayoutListenerArray[n];
            listener.columnLayoutChanged();
            ++n;
        }
    }

    private void fireSortedColumnChanged(int col) {
        TableLayoutListener[] array;
        TableLayoutListener[] tableLayoutListenerArray = array = this.listeners.toArray(new TableLayoutListener[0]);
        int n = 0;
        int n2 = tableLayoutListenerArray.length;
        while (n < n2) {
            TableLayoutListener listener = tableLayoutListenerArray[n];
            listener.sortedColumnChanged();
            ++n;
        }
    }

    public TableColumn getColumnAt(int index) {
        return this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(String identifier) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.getColumnAt(i).getIdentifier().equals(identifier)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Iterator<TableColumn> getColumns() {
        return this.columns.iterator();
    }

    public boolean getMaintainSortOrder() {
        return this.sorter.getMaintainSortOrder();
    }

    public int getSortedColumn() {
        return this.sorter.getSortedColumn();
    }

    public JTable getTable() {
        return this.table;
    }

    public JPopupMenu getHeaderPopupMenu() {
        return this.headerPopupMenu;
    }

    public int getVisibleColumnsCount() {
        return this.table.getColumnModel().getColumnCount();
    }

    public boolean isColumnVisible(int index) {
        TableColumn column = this.getColumnAt(index);
        TableColumnModel columnModel = this.table.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            if (columnModel.getColumn(i) == column) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SortableModel.Order getSortOrder() {
        return this.sorter.getSortOrder();
    }

    public void removeTableLayoutListener(TableLayoutListener l) {
        this.listeners.remove(l);
    }

    public void restoreSelections() {
        if (this.tree != null) {
            if (this.expandedLeafs != null) {
                while (this.expandedLeafs.hasMoreElements()) {
                    TreePath path = (TreePath)this.expandedLeafs.nextElement();
                    this.tree.expandPath(path);
                }
            }
            if (this.selectedPaths != null) {
                this.tree.addSelectionPaths(this.selectedPaths);
            }
        }
    }

    public void setAllColumnsVisible(boolean visible) {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.setColumnVisible(i, visible);
            ++i;
        }
    }

    private void setAutoResizeMode(MouseEvent e) {
        if ((e.getModifiers() & 1) != 0) {
            this.table.setAutoResizeMode(1);
        } else if ((e.getModifiers() & 2) != 0) {
            this.table.setAutoResizeMode(4);
        } else {
            this.table.setAutoResizeMode(2);
        }
    }

    public void setColumnNames(String[] columnNames) {
        if (this.columns.size() != columnNames.length) {
            throw new IllegalArgumentException("Number of columns and length of columnNames must match");
        }
        int i = 0;
        while (i < columnNames.length) {
            this.columns.get(i).setHeaderValue(columnNames[i]);
            ++i;
        }
    }

    public void setColumnName(int index, String name) {
        TableColumn column = this.columns.get(index);
        column.setHeaderValue(name);
    }

    public void setColumnProperties(int index, String key) {
        TableColumn column = this.columns.get(index);
        column.setIdentifier(key);
    }

    public void setColumnProperties(int index, String key, int width) {
        TableColumn column = this.columns.get(index);
        column.setIdentifier(key);
        column.setPreferredWidth(width);
        column.setWidth(width);
    }

    public void setColumnVisible(int index, boolean visible) {
        boolean currentlyVisible = this.isColumnVisible(index);
        if (currentlyVisible == visible) {
            return;
        }
        if (visible) {
            this.table.getColumnModel().addColumn(this.getColumnAt(index));
        } else {
            this.table.getColumnModel().removeColumn(this.getColumnAt(index));
        }
        this.fireColumnVisibilityChanged(index, visible);
    }

    public void setColumnsVisible(String[] columns) {
        this.setAllColumnsVisible(false);
        int i = 0;
        while (i < columns.length) {
            int index = this.getColumnIndex(columns[i]);
            if (index != -1) {
                this.setColumnVisible(index, true);
            }
            ++i;
        }
    }

    public void setMaintainSortOrder(boolean maintainSortOrder) {
        this.sorter.setMaintainSortOrder(maintainSortOrder);
    }

    public void setTree(JTree jt) {
        this.tree = jt;
    }

    public void showPopupMenu(MouseEvent e) {
        if (this.headerPopupMenu != null) {
            this.header.setDraggedColumn(null);
            this.header.setResizingColumn(null);
            GUIHelper.showPopupMenu(this.headerPopupMenu, e.getComponent(), e.getX(), e.getY());
        }
    }

    public void sortByColumn(int modelIndex, SortableModel.Order sortOrder, boolean revert) {
        this.sortByColumn(this.table.convertColumnIndexToView(modelIndex), modelIndex, sortOrder, revert);
    }

    private void sortByColumn(int column, int modelIndex, SortableModel.Order sortOrder, boolean revert) {
        this.stopCellEditing();
        this.storeSelections();
        sortOrder = this.sorter.sortByColumn(modelIndex, sortOrder, revert);
        this.renderer.setSortedColumn(column, sortOrder);
        this.restoreSelections();
    }

    private void sortByColumnInternal(int column) {
        int modelIndex = this.table.convertColumnIndexToModel(column);
        SortableModel.Order sortOrder = this.sorter.getSortedColumn() == modelIndex ? this.sorter.getSortOrder() : (this.sorter.getColumnClass(modelIndex) == String.class ? SortableModel.Order.ASCENDING : SortableModel.Order.DESCENDING);
        boolean revert = this.sorter.getSortedColumn() == modelIndex;
        this.sortByColumn(column, modelIndex, sortOrder, revert);
    }

    public void storeSelections() {
        if (this.tree != null) {
            this.selectedPaths = this.tree.getSelectionPaths();
            this.expandedLeafs = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
        }
    }

    public void stopCellEditing() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    private static class BevelArrowIcon
    implements Icon {
        public static final int DOWN = 1;
        public static final int UP = 0;
        private int direction;
        private Color edge1;
        private Color edge2;

        public BevelArrowIcon(int direction, boolean isPressedView) {
            this.direction = direction;
            if (isPressedView) {
                this.edge1 = UIManager.getColor("controlDkShadow");
                this.edge2 = UIManager.getColor("controlLtHighlight");
            } else {
                this.edge1 = UIManager.getColor("controlShadow");
                this.edge2 = UIManager.getColor("controlHighlight");
            }
        }

        public int getIconHeight() {
            return 7;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            switch (this.direction) {
                case 1: {
                    g.setColor(this.edge2);
                    g.drawLine(x + 5, y + 7, x + 8, y);
                    g.setColor(this.edge1);
                    g.drawLine(x, y, x + 8, y);
                    g.drawLine(x, y, x + 4, y + 7);
                    break;
                }
                case 0: {
                    g.setColor(this.edge1);
                    g.drawLine(x, y + 6, x + 4, y);
                    g.setColor(this.edge2);
                    g.drawLine(x, y + 7, x + 8, y + 7);
                    g.drawLine(x + 5, y, x + 8, y + 7);
                }
            }
        }
    }

    protected class EventHandler
    implements MouseListener,
    MouseMotionListener,
    TableColumnModelListener,
    PropertyChangeListener {
        protected EventHandler() {
        }

        public void columnAdded(TableColumnModelEvent event) {
        }

        public void columnMarginChanged(ChangeEvent event) {
        }

        public void columnMoved(TableColumnModelEvent event) {
            int i = TableLayout.this.table.convertColumnIndexToView(TableLayout.this.sorter.getSortedColumn());
            if (i != -1) {
                TableLayout.this.renderer.setSortedColumn(i, TableLayout.this.sorter.getSortOrder());
            }
            TableLayout.this.fireColumnOrderChanged();
        }

        public void columnRemoved(TableColumnModelEvent event) {
        }

        public void columnSelectionChanged(ListSelectionEvent event) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (TableLayout.this.sorting) {
                TableLayout.this.sorting = false;
                TableLayout.this.renderer.selectColumn(-1);
                TableLayout.this.header.repaint();
            }
            TableLayout.this.setAutoResizeMode(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TableLayout.this.showPopupMenu(e);
            } else {
                int col = TableLayout.this.header.columnAtPoint(e.getPoint());
                TableLayout.this.renderer.selectColumn(col);
                TableLayout.this.header.repaint();
                TableLayout.this.sorting = true;
            }
            TableLayout.this.setAutoResizeMode(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TableLayout.this.showPopupMenu(e);
            } else if (TableLayout.this.sorting) {
                int col = TableLayout.this.header.columnAtPoint(e.getPoint());
                if (TableLayout.this.table.isEditing()) {
                    TableLayout.this.table.getCellEditor().stopCellEditing();
                }
                TableLayout.this.sortByColumnInternal(col);
                TableLayout.this.fireSortedColumnChanged(col);
                TableLayout.this.sorting = false;
                TableLayout.this.renderer.selectColumn(-1);
                TableLayout.this.header.repaint();
            } else {
                TableLayout.this.fireColumnWidthsChanged();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("headerValue".equals(evt.getPropertyName())) {
                TableColumn column = (TableColumn)evt.getSource();
                TableLayout.this.fireColumnNameChanged(TableLayout.this.getColumnIndex(column.getIdentifier().toString()), evt.getNewValue().toString());
            }
        }
    }

    private static class SortButtonRenderer
    implements TableCellRenderer {
        public static final Icon downIcon = new BevelArrowIcon(1, false);
        public static final Icon upIcon = new BevelArrowIcon(0, false);
        private Hashtable<Integer, Icon> icons = new Hashtable();
        private JLabel label;
        private TableCellRenderer renderer;
        private int selectedColumn = -1;

        public SortButtonRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            if (renderer instanceof JLabel) {
                this.label = (JLabel)((Object)renderer);
                this.label.setHorizontalTextPosition(2);
            } else {
                this.label = new JLabel();
            }
        }

        public Icon getIcon(int col) {
            return this.icons.get(new Integer(col));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.label.setIcon(this.getIcon(column));
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == this.selectedColumn) {
                this.label.setBackground(UIManager.getColor("controlShadow"));
            }
            return c;
        }

        public void selectColumn(int col) {
            this.selectedColumn = col;
        }

        public void setSortedColumn(int col, SortableModel.Order sortOrder) {
            this.icons.clear();
            if (sortOrder == SortableModel.Order.ASCENDING) {
                this.icons.put(new Integer(col), downIcon);
            } else if (sortOrder == SortableModel.Order.DESCENDING) {
                this.icons.put(new Integer(col), upIcon);
            }
        }
    }
}

