/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.action.AbstractToggleAction;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.gui.table.TableLayoutListener;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TableHeaderMenu
extends JMenu {
    private List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    private TableLayout tableLayout;
    private TableLayoutListener layoutListener = new TableLayoutHandler();
    private CheckBoxHandler checkBoxListener = new CheckBoxHandler();
    private MaintainSortOrderAction sortOrderAction;

    public TableHeaderMenu(String name, TableLayout tableLayout, int skip) {
        super(name);
        this.setTableLayout(tableLayout);
    }

    public TableHeaderMenu(String name, TableLayout handler) {
        this(name, handler, 0);
    }

    public void updateVisibleColumns() {
    }

    public void setTableLayout(TableLayout tableLayout) {
        if (this.tableLayout != null) {
            this.tableLayout.removeTableLayoutListener(this.layoutListener);
            for (AbstractButton button : this.buttons) {
                button.removeActionListener(this.checkBoxListener);
                this.remove(button);
            }
            this.buttons.clear();
        }
        this.tableLayout = tableLayout;
        if (this.tableLayout != null) {
            int i = 0;
            while (i < tableLayout.getColumnCount()) {
                JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem(tableLayout.getColumnAt(i).getHeaderValue().toString());
                checkBox.setActionCommand(Integer.toString(i));
                checkBox.addActionListener(this.checkBoxListener);
                checkBox.setSelected(tableLayout.isColumnVisible(i));
                this.buttons.add(checkBox);
                this.add(checkBox);
                ++i;
            }
            this.sortOrderAction = new MaintainSortOrderAction();
            this.addSeparator();
            this.add(Builder.createMenuItem(this.sortOrderAction));
            this.updateVisibleColumns();
            tableLayout.addTableLayoutListener(this.layoutListener);
        }
    }

    private class TableLayoutHandler
    implements TableLayoutListener {
        TableLayoutHandler() {
        }

        public void columnLayoutChanged() {
        }

        public void sortedColumnChanged() {
        }

        public void columnOrderChanged() {
        }

        public void columnNameChanged(int index, String newName) {
            ((AbstractButton)TableHeaderMenu.this.buttons.get(index)).setText(newName);
        }

        public void columnVisibilityChanged(int index, boolean visible) {
            ((AbstractButton)TableHeaderMenu.this.buttons.get(index)).setSelected(visible);
        }

        public void maintainSortOrderChanged(boolean newValue) {
            if (TableHeaderMenu.this.sortOrderAction != null) {
                TableHeaderMenu.this.sortOrderAction.setSelected(newValue);
            }
        }
    }

    private class CheckBoxHandler
    implements ActionListener {
        CheckBoxHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)event.getSource();
            if (!checkBox.isSelected() && TableHeaderMenu.this.tableLayout.getVisibleColumnsCount() == 1) {
                checkBox.setSelected(true);
                return;
            }
            int index = Integer.parseInt(checkBox.getActionCommand());
            TableHeaderMenu.this.tableLayout.setColumnVisible(index, checkBox.isSelected());
        }
    }

    protected class MaintainSortOrderAction
    extends AbstractToggleAction {
        static /* synthetic */ Class class$0;

        public MaintainSortOrderAction() {
            I18n i18n = I18nFactory.getI18n(TableHeaderMenu.class);
            this.putValue("Name", i18n.tr("Maintain Sort Order"));
            this.putValue("ShortDescription", i18n.tr("If enabled, the sort order will be maintained as newitems are added to the table"));
        }

        public void toggled(boolean visible) {
            TableHeaderMenu.this.tableLayout.setMaintainSortOrder(visible);
        }
    }
}

