/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.table.DefaultTableCellRenderer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.util.Progress;
import org.xnap.commons.util.StringHelper;

public class ProgressCellRenderer
extends DefaultTableCellRenderer {
    private static final I18n i18n = I18nFactory.getI18n(ProgressCellRenderer.class);
    private static Color runningColor = Color.magenta;
    private static Color finishedColor = Color.green;
    private Progress value = new Progress();
    private String text;
    static /* synthetic */ Class class$0;

    protected void setValue(Object value) {
        this.value = value instanceof Progress ? (Progress)value : new Progress();
        this.text = this.getProgressText();
        this.setToolTipText(String.valueOf(String.format("%f.2", this.value.getPercent())) + "%" + (this.text.length() == 0 ? "" : ", " + this.text));
        super.setValue(null);
    }

    public String getProgressText() {
        long rate = this.value.getRate();
        if (rate < 0L) {
            return "";
        }
        if (rate == 0L) {
            return i18n.tr("stalled");
        }
        return i18n.tr(String.valueOf(StringHelper.formatSize(rate)) + "/s");
    }

    public void paint(Graphics g) {
        super.paint(g);
        double progress = this.value.getPercent();
        int xoff = 1;
        int yoff = 1;
        int height = this.getHeight() - 3;
        int width = this.getWidth() - 2;
        if (progress > 0.0) {
            g.setColor(progress < 100.0 ? runningColor : finishedColor);
            g.fillRect(xoff, yoff, width * (int)progress / 100, height);
        }
        if (this.text != null && this.text.length() > 0) {
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.text);
            int x = (this.getWidth() - w) / 2;
            int y = this.getHeight() - 4;
            g.setColor(this.getForeground());
            g.drawString(this.text, x > 1 ? x : 1, y);
        }
        g.setColor(Color.lightGray);
        g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 3);
    }
}

