/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import javax.swing.table.DefaultTableCellRenderer;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    private int precision;
    private long minValue;
    private String formatString;

    public NumberCellRenderer(long minValue, int precision) {
        this.minValue = minValue;
        this.setPrecision(precision);
        this.setHorizontalAlignment(4);
    }

    public NumberCellRenderer(long minValue) {
        this(minValue, 0);
    }

    public NumberCellRenderer() {
        this(0L, 0);
    }

    public void setPrecision(int newValue) {
        this.setFormatString("%,f." + this.precision);
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setValue(Object value) {
        double d;
        if (value instanceof Number && (d = ((Number)value).doubleValue()) >= (double)this.minValue) {
            super.setValue(String.format(this.formatString, d));
            return;
        }
        super.setValue(null);
    }
}

