/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleTableModel<T>
extends AbstractTableModel {
    private Class[] columnClasses;
    private List<T> data = new ArrayList<T>(0);

    public AbstractSimpleTableModel(Class[] columnClasses) {
        this.columnClasses = columnClasses;
    }

    public void add(int index, T item) {
        this.data.add(index, item);
        this.fireTableRowsInserted(index, index);
    }

    public void add(int index, T[] items) {
        T[] TArray = items;
        int n = 0;
        int n2 = TArray.length;
        while (n < n2) {
            T item = TArray[n];
            this.data.add(index, item);
            ++n;
        }
        this.fireTableRowsInserted(index, index + items.length - 1);
    }

    public void add(T item) {
        this.add(this.data.size(), item);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnClasses.length;
    }

    public List<T> getData() {
        return this.data;
    }

    public T getItem(int row) {
        return this.data.get(row);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public void remove(int index) {
        this.data.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void remove(int firstRow, int lastRow) {
        int i = firstRow;
        while (i <= lastRow) {
            this.data.remove(firstRow);
            ++i;
        }
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    public boolean remove(T item) {
        int index = this.data.indexOf(item);
        if (index != -1) {
            this.data.remove(index);
            this.fireTableRowsDeleted(index, index);
            return true;
        }
        return false;
    }

    public void setData(List<T> data) {
        this.data = data;
        this.fireTableDataChanged();
    }
}

