/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xnap.commons.gui.ColoredTable;
import org.xnap.commons.gui.shortcut.KeyStrokePanel;
import org.xnap.commons.gui.shortcut.Shortcut;
import org.xnap.commons.gui.table.AbstractSimpleTableModel;
import org.xnap.commons.gui.table.TableLayoutManager;
import org.xnap.commons.gui.table.TableSorter;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ShortcutPanel
extends JPanel {
    private static I18n i18n = I18nFactory.getI18n(ShortcutPanel.class);
    private KeyStrokePanel keyStrokePanel;
    private ColoredTable shortcutTable;
    private TableLayoutManager shortcutTableLayoutManager;
    private ShortcutTableModel shortcutTableModel;
    private ShortcutProxy selectedProxy;
    static /* synthetic */ Class class$0;

    public ShortcutPanel() {
        this.setLayout(new BorderLayout());
        this.shortcutTableModel = new ShortcutTableModel();
        TableSorter sorter = new TableSorter(this.shortcutTableModel);
        this.shortcutTable = new ColoredTable(sorter);
        this.shortcutTableLayoutManager = new TableLayoutManager(this.shortcutTable);
        this.shortcutTableLayoutManager.addColumnProperties("description", i18n.tr("Action"), 80, true);
        this.shortcutTableLayoutManager.addColumnProperties("category", i18n.tr("Category"), 60, true);
        this.shortcutTableLayoutManager.addColumnProperties("shortcut", i18n.tr("Shortcut"), 40, true);
        this.shortcutTableLayoutManager.getTableLayout().setMaintainSortOrder(true);
        this.shortcutTableLayoutManager.initializeTableLayout();
        this.shortcutTable.setIntercellSpacing(new Dimension(2, 1));
        this.shortcutTable.setShowVerticalLines(true);
        this.shortcutTable.setShowHorizontalLines(false);
        this.shortcutTable.setSelectionMode(0);
        this.shortcutTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                ShortcutPanel.this.applySelectedKeyStroke();
                ShortcutPanel.this.selectedProxy = ShortcutPanel.this.getSelectedShortcut();
                if (ShortcutPanel.this.selectedProxy != null) {
                    ShortcutPanel.this.keyStrokePanel.setKeyStroke(ShortcutPanel.this.selectedProxy.getKeyStroke());
                    ShortcutPanel.this.keyStrokePanel.setDefaultKeyStroke(ShortcutPanel.this.selectedProxy.getDefaultKeyStroke());
                    ShortcutPanel.this.keyStrokePanel.setEnabled(true);
                } else {
                    ShortcutPanel.this.keyStrokePanel.setKeyStroke(null);
                    ShortcutPanel.this.keyStrokePanel.setDefaultKeyStroke(null);
                    ShortcutPanel.this.keyStrokePanel.setEnabled(false);
                }
            }
        });
        this.add((Component)new JScrollPane(this.shortcutTable), "Center");
        this.keyStrokePanel = new KeyStrokePanel();
        this.keyStrokePanel.setBorder(GUIHelper.createTitledBorder(i18n.tr("Shortcut for Selected Action"), 5));
        this.keyStrokePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ShortcutPanel.this.applySelectedKeyStroke();
            }
        });
        this.keyStrokePanel.setEnabled(false);
        this.add((Component)this.keyStrokePanel, "South");
    }

    public void add(Shortcut shortcut, KeyStroke defaultKeyStroke) {
        this.shortcutTableModel.add(new ShortcutProxy(shortcut, defaultKeyStroke));
    }

    public void apply() {
        this.applySelectedKeyStroke();
        List data = this.shortcutTableModel.getData();
        for (ShortcutProxy proxy : data) {
            proxy.getShortcut().setKeyStroke(proxy.getKeyStroke());
        }
    }

    public void applySelectedKeyStroke() {
        if (this.selectedProxy != null) {
            this.selectedProxy.setKeyStroke(this.keyStrokePanel.getKeyStroke());
            this.shortcutTableModel.changed(this.selectedProxy);
        }
    }

    protected int getSelectedRow() {
        int row = this.shortcutTable.getSelectedRow();
        return row == -1 ? -1 : ((TableSorter)this.shortcutTable.getModel()).mapToIndex(row);
    }

    protected ShortcutProxy getSelectedShortcut() {
        int row = this.getSelectedRow();
        return row == -1 ? null : (ShortcutProxy)this.shortcutTableModel.getItem(row);
    }

    public String getTitle() {
        return i18n.tr("Shortcuts");
    }

    private class ShortcutProxy {
        private KeyStroke defaultKeyStroke;
        private KeyStroke keyStroke;
        private Shortcut shortcut;

        public ShortcutProxy(Shortcut shortcut, KeyStroke defaultKeyStroke) {
            this.shortcut = shortcut;
            this.keyStroke = shortcut.getKeyStroke();
            this.defaultKeyStroke = defaultKeyStroke;
        }

        public KeyStroke getDefaultKeyStroke() {
            return this.defaultKeyStroke;
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public Shortcut getShortcut() {
            return this.shortcut;
        }

        public void setKeyStroke(KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortcutTableModel
    extends AbstractSimpleTableModel<ShortcutProxy> {
        static /* synthetic */ Class class$0;

        public ShortcutTableModel() {
            super(new Class[]{String.class, String.class, String.class});
        }

        public void changed(ShortcutProxy selectedProxy) {
            int i = this.getData().indexOf(selectedProxy);
            if (i != -1) {
                this.fireTableRowsUpdated(i, i);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            ShortcutProxy proxy = (ShortcutProxy)this.getItem(row);
            switch (column) {
                case 0: {
                    return proxy.getShortcut().getValue("XNapDescription");
                }
                case 1: {
                    return proxy.getShortcut().getValue("XNapCategory");
                }
                case 2: {
                    return proxy.getKeyStroke() != null ? KeyStrokePanel.toString(proxy.getKeyStroke()) : null;
                }
            }
            return null;
        }
    }
}

