/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.xnap.commons.settings.KeyStrokeSetting;

public class MediatorShortcut {
    private JComponent component;
    private KeyStrokeSetting setting;
    private Action action;
    private boolean enabled = true;
    private PropertyChangeHandler handler = new PropertyChangeHandler();

    public MediatorShortcut(KeyStrokeSetting setting, Action action, JComponent component) {
        this.component = component;
        this.action = action;
        this.setting = setting;
        component.getActionMap().put(action, action);
        this.updateKeyStroke(null);
        setting.addPropertyChangeListener(this.handler);
    }

    private void updateKeyStroke(KeyStroke oldStroke) {
        if (oldStroke != null && this.component.getInputMap().get(oldStroke) == this.action) {
            this.component.getInputMap().remove(oldStroke);
        }
        if (this.enabled) {
            this.component.getInputMap().put((KeyStroke)this.setting.getValue(), this.action);
        } else {
            this.component.getInputMap().remove((KeyStroke)this.setting.getValue());
        }
    }

    public JComponent getComonent() {
        return this.component;
    }

    public Action getAction() {
        return this.action;
    }

    public KeyStrokeSetting getSetting() {
        return this.setting;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.updateKeyStroke(null);
            if (enabled) {
                this.setting.addPropertyChangeListener(this.handler);
            } else {
                this.setting.removePropertyChangeListener(this.handler);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MediatorShortcut.this.updateKeyStroke((KeyStroke)evt.getOldValue());
        }
    }
}

