/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KeyStrokePanel
extends JPanel
implements ActionListener {
    private static I18n i18n = I18nFactory.getI18n(KeyStrokePanel.class);
    private JCheckBox altCheckBox;
    protected transient ChangeEvent changeEvent;
    private JToggleButton charButton;
    private JCheckBox ctrlCheckBox;
    private KeyStroke defaultKeyStroke;
    private int keyCode;
    private CharButtonListener keyListener = new CharButtonListener();
    private JCheckBox metaCheckBox;
    private JCheckBox shiftCheckBox;
    private DefaultAction defaultAction = new DefaultAction();
    private NoneAction noneAction = new NoneAction();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String toString(KeyStroke stroke) {
        StringBuilder sb = new StringBuilder();
        int m = stroke.getModifiers();
        if ((m & 2) != 0) {
            sb.append(KeyEvent.getKeyModifiersText(2));
            sb.append("+");
        }
        if ((m & 8) != 0) {
            sb.append(KeyEvent.getKeyModifiersText(8));
            sb.append("+");
        }
        if ((m & 4) != 0) {
            sb.append(KeyEvent.getKeyModifiersText(4));
            sb.append("+");
        }
        if ((m & 1) != 0) {
            sb.append(KeyEvent.getKeyModifiersText(1));
            sb.append("+");
        }
        sb.append(KeyEvent.getKeyText(stroke.getKeyCode()));
        return sb.toString();
    }

    public KeyStrokePanel() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        this.add((Component)topPanel, "North");
        this.ctrlCheckBox = new JCheckBox(KeyEvent.getKeyModifiersText(2));
        this.ctrlCheckBox.addActionListener(this);
        topPanel.add(this.ctrlCheckBox);
        this.altCheckBox = new JCheckBox(KeyEvent.getKeyModifiersText(8));
        this.altCheckBox.addActionListener(this);
        topPanel.add(this.altCheckBox);
        this.metaCheckBox = new JCheckBox(KeyEvent.getKeyModifiersText(4));
        this.metaCheckBox.addActionListener(this);
        topPanel.add(this.metaCheckBox);
        this.shiftCheckBox = new JCheckBox(KeyEvent.getKeyModifiersText(1));
        this.shiftCheckBox.addActionListener(this);
        topPanel.add(this.shiftCheckBox);
        this.charButton = new JToggleButton(" ");
        this.charButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    KeyStrokePanel.this.charButton.addKeyListener(KeyStrokePanel.this.keyListener);
                } else {
                    KeyStrokePanel.this.charButton.removeKeyListener(KeyStrokePanel.this.keyListener);
                    KeyStrokePanel.this.fireChangeEvent();
                }
            }
        });
        this.charButton.addFocusListener(new UntoggleListener());
        topPanel.add(this.charButton);
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        this.add((Component)bottomPanel, "South");
        bottomPanel.add(Builder.createButton(this.defaultAction));
        bottomPanel.add(Builder.createButton(this.noneAction));
    }

    public void actionPerformed(ActionEvent e) {
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public KeyStroke getKeyStroke() {
        if (this.keyCode == 0) {
            return null;
        }
        int m = 0;
        m |= this.ctrlCheckBox.isSelected() ? 2 : 0;
        m |= this.altCheckBox.isSelected() ? 8 : 0;
        m |= this.metaCheckBox.isSelected() ? 4 : 0;
        return KeyStroke.getKeyStroke(this.keyCode, m |= this.shiftCheckBox.isSelected() ? 1 : 0);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ctrlCheckBox.setEnabled(enabled);
        this.altCheckBox.setEnabled(enabled);
        this.metaCheckBox.setEnabled(enabled);
        this.shiftCheckBox.setEnabled(enabled);
        this.charButton.setEnabled(enabled);
        this.defaultAction.setEnabled(enabled);
        this.noneAction.setEnabled(enabled);
    }

    public void setDefaultKeyStroke(KeyStroke defaultKeyStroke) {
        this.defaultKeyStroke = defaultKeyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            int m = keyStroke.getModifiers();
            this.ctrlCheckBox.setSelected((m & 2) != 0);
            this.altCheckBox.setSelected((m & 8) != 0);
            this.metaCheckBox.setSelected((m & 4) != 0);
            this.shiftCheckBox.setSelected((m & 1) != 0);
            this.keyCode = keyStroke.getKeyCode();
            this.charButton.setText(KeyEvent.getKeyText(this.keyCode));
        } else {
            this.ctrlCheckBox.setSelected(false);
            this.altCheckBox.setSelected(false);
            this.metaCheckBox.setSelected(false);
            this.shiftCheckBox.setSelected(false);
            this.charButton.setText(" ");
            this.keyCode = 0;
        }
    }

    private class CharButtonListener
    extends KeyAdapter {
        CharButtonListener() {
        }

        public void keyPressed(KeyEvent e) {
            KeyStrokePanel.this.keyCode = e.getKeyCode();
            KeyStrokePanel.this.charButton.setSelected(false);
            KeyStrokePanel.this.charButton.setText(KeyEvent.getKeyText(KeyStrokePanel.this.keyCode));
        }
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", i18n.tr("Default"));
            this.putValue("ShortDescription", i18n.tr("Reset to default"));
        }

        public void actionPerformed(ActionEvent event) {
            KeyStrokePanel.this.setKeyStroke(KeyStrokePanel.this.defaultKeyStroke);
            KeyStrokePanel.this.fireChangeEvent();
        }
    }

    private class NoneAction
    extends AbstractAction {
        public NoneAction() {
            this.putValue("Name", i18n.tr("None"));
            this.putValue("ShortDescription", i18n.tr("Assigns no keystroke"));
        }

        public void actionPerformed(ActionEvent event) {
            KeyStrokePanel.this.setKeyStroke(null);
            KeyStrokePanel.this.fireChangeEvent();
        }
    }

    private class UntoggleListener
    extends FocusAdapter {
        UntoggleListener() {
        }

        public void focusLost(FocusEvent e) {
            KeyStrokePanel.this.charButton.setSelected(false);
        }
    }
}

