/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmacsKeyBindings {
    public static final String killLineAction = "emacs-kill-line";
    public static final String killRingSaveAction = "emacs-kill-ring-save";
    public static final String killRegionAction = "emacs-kill-region";
    public static final String backwardKillWordAction = "emacs-backward-kill-word";
    public static final String capitalizeWordAction = "emacs-capitalize-word";
    public static final String downcaseWordAction = "emacs-downcase-word";
    public static final String killWordAction = "emacs-kill-word";
    public static final String setMarkCommandAction = "emacs-set-mark-command";
    public static final String yankAction = "emacs-yank";
    public static final String yankPopAction = "emacs-yank-pop";
    public static final String upcaseWordAction = "emacs-upcase-word";
    public static final JTextComponent.KeyBinding[] EMACS_KEY_BINDINGS = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 8), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 2), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(69, 2), "caret-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, 2), "caret-begin-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 2), "delete-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(78, 2), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(80, 2), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 8), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 8), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 9), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 8), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 2), "caret-forward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 2), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 2), "page-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 8), "page-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 8), "emacs-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, 8), "emacs-backward-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(32, 2), "emacs-set-mark-command"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 8), "emacs-kill-ring-save"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 2), "emacs-kill-region"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(75, 2), "emacs-kill-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "emacs-yank"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 8), "emacs-yank-pop"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, 8), "emacs-capitalize-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(76, 8), "emacs-downcase-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(85, 8), "emacs-upcase-word")};
    private static Log logger = LogFactory.getLog(EmacsKeyBindings.class);
    static /* synthetic */ Class class$0;

    public static void load() {
        JTextComponent[] jtcs = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};
        int i = 0;
        while (i < jtcs.length) {
            Keymap orig = jtcs[i].getKeymap();
            Keymap backup = JTextComponent.addKeymap(jtcs[i].getClass().getName(), null);
            Action[] bound = orig.getBoundActions();
            int j = 0;
            while (j < bound.length) {
                KeyStroke[] strokes = orig.getKeyStrokesForAction(bound[j]);
                int k = 0;
                while (k < strokes.length) {
                    backup.addActionForKeyStroke(strokes[k], bound[j]);
                    ++k;
                }
                ++j;
            }
            backup.setDefaultAction(orig.getDefaultAction());
            ++i;
        }
        EmacsKeyBindings.loadEmacsKeyBindings();
    }

    public static void unload() {
        JTextComponent[] jtcs = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};
        int i = 0;
        while (i < jtcs.length) {
            Keymap backup = JTextComponent.getKeymap(jtcs[i].getClass().getName());
            if (backup != null) {
                Keymap current = jtcs[i].getKeymap();
                current.removeBindings();
                Action[] bound = backup.getBoundActions();
                int j = 0;
                while (j < bound.length) {
                    KeyStroke[] strokes = backup.getKeyStrokesForAction(bound[i]);
                    int k = 0;
                    while (k < strokes.length) {
                        current.addActionForKeyStroke(strokes[k], bound[j]);
                        ++k;
                    }
                    ++j;
                }
                current.setDefaultAction(backup.getDefaultAction());
            }
            ++i;
        }
    }

    private static void loadEmacsKeyBindings() {
        logger.debug("Loading emacs keybindings");
        JTextComponent[] jtcs = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};
        int i = 0;
        while (i < jtcs.length) {
            Keymap k = jtcs[i].getKeymap();
            JTextComponent.loadKeymap(k, EMACS_KEY_BINDINGS, jtcs[i].getActions());
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(68, 8), new KillWordAction(killWordAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(8, 8), new BackwardKillWordAction(backwardKillWordAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(32, 2), new SetMarkCommandAction(setMarkCommandAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 8), new KillRingSaveAction(killRingSaveAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 2), new KillRegionAction(killRegionAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(75, 2), new KillLineAction(killLineAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(89, 2), new YankAction(yankAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(89, 8), new YankPopAction(yankPopAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 8), new CapitalizeWordAction(capitalizeWordAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(76, 8), new DowncaseWordAction(downcaseWordAction));
            k.addActionForKeyStroke(KeyStroke.getKeyStroke(85, 8), new UpcaseWordAction(upcaseWordAction));
            ++i;
        }
    }

    private static int getWordEnd(JTextComponent jtc, int start) throws BadLocationException {
        try {
            return Utilities.getNextWord(jtc, start);
        }
        catch (BadLocationException ble) {
            int end = jtc.getText().length();
            if (start < end) {
                return end;
            }
            throw ble;
        }
    }

    public static class KillWordAction
    extends TextAction {
        public KillWordAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int offs = jtc.getCaretPosition();
                    jtc.setSelectionStart(offs);
                    offs = EmacsKeyBindings.getWordEnd(jtc, offs);
                    jtc.setSelectionEnd(offs);
                    KillRing.getInstance().add(jtc.getSelectedText());
                    jtc.cut();
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardKillWordAction
    extends TextAction {
        public BackwardKillWordAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int offs = jtc.getCaretPosition();
                    jtc.setSelectionEnd(offs);
                    offs = Utilities.getPreviousWord(jtc, offs);
                    jtc.setSelectionStart(offs);
                    KillRing.getInstance().add(jtc.getSelectedText());
                    jtc.cut();
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class KillRingSaveAction
    extends TextAction {
        public KillRingSaveAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null && SetMarkCommandAction.isMarked(jtc)) {
                jtc.setSelectionStart(SetMarkCommandAction.getCaretPosition());
                jtc.moveCaretPosition(jtc.getCaretPosition());
                jtc.copy();
                KillRing.getInstance().add(jtc.getSelectedText());
                SetMarkCommandAction.reset();
            }
        }
    }

    public static class KillRegionAction
    extends TextAction {
        public KillRegionAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null && SetMarkCommandAction.isMarked(jtc)) {
                int end;
                int start;
                if (SetMarkCommandAction.getCaretPosition() < jtc.getCaretPosition()) {
                    start = SetMarkCommandAction.getCaretPosition();
                    end = jtc.getCaretPosition();
                } else {
                    start = jtc.getCaretPosition();
                    end = SetMarkCommandAction.getCaretPosition();
                }
                if (start != end) {
                    jtc.select(start, end);
                    SetMarkCommandAction.reset();
                    KillRing.getInstance().add(jtc.getSelectedText());
                    jtc.cut();
                } else {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class KillLineAction
    extends TextAction {
        public KillLineAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = Utilities.getRowEnd(jtc, start);
                    if (start == end && jtc.isEditable()) {
                        Document doc = jtc.getDocument();
                        doc.remove(end, 1);
                    } else {
                        jtc.setSelectionStart(start);
                        jtc.setSelectionEnd(end);
                        KillRing.getInstance().add(jtc.getSelectedText());
                        jtc.cut();
                    }
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class SetMarkCommandAction
    extends TextAction {
        private static int position = -1;
        private static JTextComponent jtc;

        public SetMarkCommandAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            jtc = this.getTextComponent(e);
            if (jtc != null) {
                position = jtc.getCaretPosition();
            }
        }

        public static boolean isMarked(JTextComponent jt) {
            return jtc == jt && position != -1;
        }

        public static void reset() {
            jtc = null;
            position = -1;
        }

        public static int getCaretPosition() {
            return position;
        }
    }

    public static class YankAction
    extends TextAction {
        public static int start = -1;
        public static int end = -1;

        public YankAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    start = jtc.getCaretPosition();
                    jtc.paste();
                    end = jtc.getCaretPosition();
                    KillRing.getInstance().add(jtc.getText(start, end));
                    KillRing.getInstance().setCurrentTextComponent(jtc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class YankPopAction
    extends TextAction {
        public YankPopAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null && KillRing.getInstance().getCurrentTextComponent() == jtc && jtc.getCaretPosition() == YankAction.end && !KillRing.getInstance().isEmpty()) {
                jtc.setSelectionStart(YankAction.start);
                jtc.setSelectionEnd(YankAction.end);
                String toYank = KillRing.getInstance().next();
                if (toYank != null) {
                    jtc.replaceSelection(toYank);
                    YankAction.end = jtc.getCaretPosition();
                } else {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KillRing {
        private JTextComponent jtc;
        private LinkedList<String> ring = new LinkedList();
        Iterator<String> iter = this.ring.iterator();
        private static final KillRing instance = new KillRing();

        public static KillRing getInstance() {
            return instance;
        }

        void setCurrentTextComponent(JTextComponent jtc) {
            this.jtc = jtc;
        }

        JTextComponent getCurrentTextComponent() {
            return this.jtc;
        }

        void add(String text) {
            if (text.length() == 0) {
                return;
            }
            this.ring.remove(text);
            this.ring.addFirst(text);
            while (this.ring.size() > 60) {
                this.ring.removeLast();
            }
            this.iter = this.ring.iterator();
            this.iter.next();
        }

        public List<String> getRing() {
            return Collections.unmodifiableList(this.ring);
        }

        public boolean isEmpty() {
            return this.ring.isEmpty();
        }

        String next() {
            if (this.ring.isEmpty()) {
                return null;
            }
            if (this.iter.hasNext()) {
                return this.iter.next();
            }
            this.iter = this.ring.iterator();
            return this.iter.next();
        }
    }

    public static class CapitalizeWordAction
    extends TextAction {
        public CapitalizeWordAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toLowerCase());
                    int offs = Utilities.getWordStart(jtc, start);
                    String c = jtc.getText(offs, 1);
                    if (c.equals(" ")) {
                        ++offs;
                        offs = Utilities.getWordStart(jtc, offs);
                        c = jtc.getText(offs, 1);
                    }
                    if (Character.isLetter(c.charAt(0))) {
                        jtc.setSelectionStart(offs);
                        jtc.setSelectionEnd(offs + 1);
                        jtc.replaceSelection(c.toUpperCase());
                    }
                    end = Utilities.getWordEnd(jtc, offs);
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class DowncaseWordAction
    extends TextAction {
        public DowncaseWordAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toLowerCase());
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class UpcaseWordAction
    extends TextAction {
        public UpcaseWordAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toUpperCase());
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }
}

