/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.xnap.commons.gui.shortcut.AbstractShortcut;

public class ActionShortcut
extends AbstractShortcut {
    private Action action;
    private LinkedList<JComponent> components = new LinkedList();
    private JMenuItem menuItem;

    public ActionShortcut(Action action, JComponent c) {
        this.action = action;
        this.addComponent(c, action);
    }

    public ActionShortcut(Action action) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        this.action = action;
    }

    public void addComponent(JComponent c, Action a) {
        c.getActionMap().put(this, a);
        this.components.add(c);
        this.setKeyStroke(this.getKeyStroke(), c);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public Action getAction() {
        return this.action;
    }

    public void setMenuItem(JMenuItem menuItem) {
        if (this.menuItem != null) {
            this.menuItem.setAccelerator(null);
        }
        this.menuItem = menuItem;
        if (this.menuItem != null) {
            this.menuItem.setAccelerator(this.getKeyStroke());
        }
    }

    public void removeComponent(JComponent c) {
        c.getActionMap().remove(this);
        this.components.remove(c);
    }

    public int getNumberOfComponents() {
        return this.components.size();
    }

    private void setKeyStroke(KeyStroke stroke, JComponent c) {
        InputMap m = c.getInputMap(1);
        if (this.getKeyStroke() != null) {
            m.remove(this.getKeyStroke());
        }
        if (stroke != null) {
            m.put(stroke, this);
        }
    }

    public void setKeyStroke(KeyStroke stroke) {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            this.setKeyStroke(stroke, (JComponent)i.next());
        }
        if (this.menuItem != null) {
            this.menuItem.setAccelerator(stroke);
        }
        super.setKeyStroke(stroke);
    }
}

