/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.settings;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.settings.IntSetting;
import org.xnap.commons.settings.Setting;
import org.xnap.commons.settings.StringSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingComponentMediator {
    private List<SettingMapper> mappers = new LinkedList<SettingMapper>();

    public void add(BooleanSetting setting, AbstractButton button) {
        this.mappers.add(new BooleanSettingMapper(setting, button));
    }

    public void add(IntSetting setting, SpinnerNumberModel spinnerModel) {
        this.mappers.add(new IntSettingMapper(setting, spinnerModel));
    }

    public void add(StringSetting setting, JTextComponent textComponent) {
        this.mappers.add(new StringSettingMapper(setting, textComponent));
    }

    public <T> void add(Setting<T> setting, ComboBoxModel model) {
        this.mappers.add(new SelectionMapper<T>(setting, model));
    }

    public void add(SettingMapper mapper) {
        this.mappers.add(mapper);
    }

    public void remove(SettingMapper mapper) {
        this.mappers.remove(mapper);
    }

    public Iterator<SettingMapper> iterator() {
        return this.mappers.iterator();
    }

    public void apply() {
        for (SettingMapper mapper : this.mappers) {
            mapper.apply();
        }
    }

    public void revert() {
        for (SettingMapper mapper : this.mappers) {
            mapper.revert();
        }
    }

    public void revertToDefaults() {
        for (SettingMapper mapper : this.mappers) {
            mapper.revertToDefaults();
        }
    }

    public static interface SettingMapper {
        public void apply();

        public void revert();

        public void revertToDefaults();
    }

    public static class BooleanSettingMapper
    implements SettingMapper {
        private AbstractButton button;
        private BooleanSetting setting;

        public BooleanSettingMapper(BooleanSetting setting, AbstractButton button) {
            this.setting = setting;
            this.button = button;
        }

        public void apply() {
            this.setting.setValue(this.button.isSelected());
        }

        public void revert() {
            this.button.setSelected((Boolean)this.setting.getValue());
        }

        public void revertToDefaults() {
            this.button.setSelected((Boolean)this.setting.getDefaultValue());
        }
    }

    public static class StringSettingMapper
    implements SettingMapper {
        private StringSetting setting;
        private JTextComponent textComponent;

        public StringSettingMapper(StringSetting setting, JTextComponent textComponent) {
            this.setting = setting;
            this.textComponent = textComponent;
        }

        public void apply() {
            this.setting.setValue(this.textComponent.getText());
        }

        public void revert() {
            this.textComponent.setText((String)this.setting.getValue());
        }

        public void revertToDefaults() {
            this.textComponent.setText((String)this.setting.getDefaultValue());
        }
    }

    public static class IntSettingMapper
    implements SettingMapper {
        private IntSetting setting;
        private SpinnerNumberModel spinnerModel;

        public IntSettingMapper(IntSetting setting, SpinnerNumberModel spinnerModel) {
            this.setting = setting;
            this.spinnerModel = spinnerModel;
        }

        public void apply() {
            this.setting.setValue(this.spinnerModel.getNumber().intValue());
        }

        public void revert() {
            this.spinnerModel.setValue(this.setting.getValue());
        }

        public void revertToDefaults() {
            this.spinnerModel.setValue(this.setting.getDefaultValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectionMapper<T>
    implements SettingMapper {
        private Setting<T> setting;
        private ComboBoxModel model;

        public SelectionMapper(Setting<T> setting, ComboBoxModel model) {
            this.setting = setting;
            this.model = model;
        }

        @Override
        public void apply() {
            this.setting.setValue(this.model.getSelectedItem());
        }

        @Override
        public void revert() {
            this.model.setSelectedItem(this.setting.getValue());
        }

        @Override
        public void revertToDefaults() {
            this.model.setSelectedItem(this.setting.getDefaultValue());
        }
    }
}

