/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.factory;

import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.xnap.commons.gui.TextFieldMenu;
import org.xnap.commons.gui.ToolBarButton;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.action.ToggleAction;
import org.xnap.commons.gui.completion.ClearCompletionModelAction;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.CompletionModeMenu;
import org.xnap.commons.gui.completion.DefaultCompletionModel;
import org.xnap.commons.gui.factory.Factory;
import org.xnap.commons.gui.util.PopupListener;

public class DefaultFactory
implements Factory {
    public static final String ENHANCED_TEXT_FIELD_MENU_KEY = "enhancedTextFieldMenu";
    private Map<Object, Object> properties;

    public void addCompletionModeMenu(JTextComponent textComponent, Completion completion) {
        if (this.getProperty(ENHANCED_TEXT_FIELD_MENU_KEY) != null) {
            TextFieldMenu menu = new TextFieldMenu();
            menu.addSeparator();
            menu.add(new CompletionModeMenu(completion));
            textComponent.addMouseListener(new PopupListener(menu));
            if (completion.getModel() instanceof DefaultCompletionModel) {
                menu.addSeparator();
                ClearCompletionModelAction action = new ClearCompletionModelAction((DefaultCompletionModel)completion.getModel());
                menu.add(this.createMenuItem(action));
            }
        } else {
            CompletionModeMenu menu = new CompletionModeMenu(completion);
            textComponent.addMouseListener(new PopupListener(menu));
        }
    }

    public void addCompletionModeMenu(JMenu menu, Completion completion) {
        menu.add(new CompletionModeMenu(completion));
    }

    public AbstractButton createButton(Action action) {
        AbstractButton button = action instanceof ToggleAction ? new JToggleButton(action) : new JButton(action);
        AbstractXNapAction.initialize(button, action);
        return button;
    }

    public AbstractButton createCheckBox(ToggleAction action) {
        JCheckBox button = new JCheckBox(action);
        AbstractXNapAction.initialize(button, action);
        return button;
    }

    public AbstractButton createIconButton(Action action) {
        JButton button = new JButton(action);
        button.setMargin(new Insets(1, 1, 1, 1));
        AbstractXNapAction.initialize(button, action);
        return button;
    }

    public AbstractButton createToolBarButton(Action action) {
        ToolBarButton button = new ToolBarButton(action);
        AbstractXNapAction.initialize(button, action);
        return button;
    }

    public JComponent createMenuItem(Action action) {
        if (action == null) {
            return new JPopupMenu.Separator();
        }
        if (action instanceof ToggleAction) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(action);
            AbstractXNapAction.initialize(menuItem, action);
            return menuItem;
        }
        JMenuItem menuItem = new JMenuItem(action);
        AbstractXNapAction.initialize(menuItem, action);
        return menuItem;
    }

    public Object getProperty(Object key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.put(key, value);
    }
}

