/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.xnap.commons.gui.dnd.AbstractFileTransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferable
implements Transferable {
    private final List<File> files;

    public FileTransferable(List<File> files) {
        if (files == null) {
            throw new NullPointerException("files must not be null");
        }
        this.files = files;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, AbstractFileTransferHandler.linuxURIFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.javaFileListFlavor.equals(flavor) || AbstractFileTransferHandler.linuxURIFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            return this.files;
        }
        if (AbstractFileTransferHandler.linuxURIFlavor.equals(flavor)) {
            StringBuilder sb = new StringBuilder();
            String lineSep = System.getProperty("line.separator");
            for (File file : this.files) {
                URL url = file.toURL();
                if (sb.length() > 0) {
                    sb.append(lineSep);
                }
                sb.append(url.toExternalForm());
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

