/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.dnd;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.dnd.AbstractFileTransferHandler;
import org.xnap.commons.gui.dnd.FileTransferable;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.io.Job;
import org.xnap.commons.io.JobExecutor;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.io.SubTaskProgressMonitor;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.settings.PropertyResource;
import org.xnap.commons.util.FileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeFileTransferHandler
extends AbstractFileTransferHandler {
    private static final I18n i18n = I18nFactory.getI18n(DefaultTreeFileTransferHandler.class);
    private BooleanSetting showCopyDialog;
    static /* synthetic */ Class class$0;

    public DefaultTreeFileTransferHandler(BooleanSetting showCopyDialog) {
        if (showCopyDialog == null) {
            throw new NullPointerException("showCopyDialog must not be null");
        }
        this.showCopyDialog = showCopyDialog;
    }

    public DefaultTreeFileTransferHandler() {
        this(new BooleanSetting(new PropertyResource(), "dummy", Boolean.FALSE));
    }

    public void setShowCopyDialogSetting(BooleanSetting setting) {
        if (setting == null) {
            throw new NullPointerException("setting must not be null");
        }
        this.showCopyDialog = setting;
    }

    public BooleanSetting getShowCopyDialogSetting() {
        return this.showCopyDialog;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] selectedPaths = tree.getSelectionPaths();
        ArrayList<File> files = new ArrayList<File>(selectedPaths.length);
        TreePath[] treePathArray = selectedPaths;
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath path = treePathArray[n];
            if (path.getLastPathComponent() instanceof File) {
                files.add((File)path.getLastPathComponent());
            }
            ++n;
        }
        if (!files.isEmpty()) {
            return new FileTransferable(files);
        }
        return null;
    }

    @Override
    public boolean importFiles(JComponent comp, List<File> files) {
        JTree tree = (JTree)comp;
        TreePath selectedPath = tree.getSelectionPath();
        if (selectedPath == null) {
            return false;
        }
        File dir = (File)selectedPath.getLastPathComponent();
        if (!dir.isDirectory()) {
            return false;
        }
        File[] filesToCopy = Dialogs.showCopyDialog(tree, files.toArray(new File[0]), dir, new BooleanSetting(new PropertyResource(), "dummy", Boolean.TRUE));
        try {
            JobExecutor.run(i18n.tr("Copying Files"), new CopyRunner(filesToCopy, dir));
        }
        catch (Exception e) {
            Dialogs.showError((Component)tree, i18n.tr("Error copying files"), e);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyRunner
    implements Job<Object> {
        private File[] files;
        private File targetPath;

        public CopyRunner(File[] files, File targetPath) {
            this.files = files;
            this.targetPath = targetPath;
        }

        @Override
        public Object run(ProgressMonitor monitor) throws Exception {
            monitor.setTotalSteps(this.files.length * 100);
            File[] fileArray = this.files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file = fileArray[n];
                File dest = FileHelper.createUnique(this.targetPath, file.getName());
                monitor.setText(i18n.tr("Copying<br>{0}<br>to<br>{1}...", file, dest));
                FileHelper.copy(file, dest, (ProgressMonitor)new SubTaskProgressMonitor(monitor, 100, file.length()));
                if (monitor.isCancelled()) {
                    return null;
                }
                ++n;
            }
            return null;
        }
    }
}

