/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.dnd;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import org.xnap.commons.gui.dnd.AbstractFileTransferHandler;
import org.xnap.commons.gui.dnd.FileTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTextFieldFileTransferHandler
extends AbstractFileTransferHandler {
    private static TransferHandler handler = new DefaultTextFieldFileTransferHandler();

    protected DefaultTextFieldFileTransferHandler() {
    }

    public static void install(JTextField textField) {
        textField.setTransferHandler(handler);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTextField textField = (JTextField)c;
        if (textField.isEnabled() && textField.getText().length() > 0) {
            return new FileTransferable(Collections.singletonList(new File(textField.getText())));
        }
        return null;
    }

    @Override
    public boolean importFiles(JComponent comp, List<File> files) {
        File file = files.get(0);
        JTextField textField = (JTextField)comp;
        textField.setText(file.getAbsolutePath());
        return true;
    }
}

