/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileTransferHandler
extends TransferHandler {
    public static DataFlavor linuxURIFlavor = AbstractFileTransferHandler.createLinuxURIFlavor();

    private static DataFlavor createLinuxURIFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        DataFlavor[] dataFlavorArray = transferFlavors;
        int n = 0;
        int n2 = dataFlavorArray.length;
        while (n < n2) {
            DataFlavor flavor = dataFlavorArray[n];
            if (flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(linuxURIFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return null;
    }

    public boolean importFiles(JComponent comp, List<File> files) {
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        ArrayList<File> files = null;
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                files = (ArrayList<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
            } else if (t.isDataFlavorSupported(linuxURIFlavor)) {
                String s = (String)t.getTransferData(linuxURIFlavor);
                StringTokenizer st = new StringTokenizer(s, System.getProperty("line.separator"));
                files = new ArrayList<File>();
                while (st.hasMoreTokens()) {
                    String file = st.nextToken();
                    try {
                        URL url = new URL(file);
                        files.add(new File(URLDecoder.decode(url.getPath())));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return files != null && !files.isEmpty() ? this.importFiles(comp, (List<File>)files) : false;
    }
}

