/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.io.File;
import java.io.FileFilter;
import javax.swing.DefaultComboBoxModel;
import org.xnap.commons.gui.completion.CompletionModel;
import org.xnap.commons.util.FileHelper;

public class FileCompletionModel
extends DefaultComboBoxModel
implements CompletionModel {
    private boolean completeOnlyDirectories = false;
    private boolean completeHiddenFiles = false;
    private FileFilter dirFilter = new DirectoryFileFilter();

    public FileCompletionModel(boolean completeOnlyDirectories) {
        this.completeOnlyDirectories = completeOnlyDirectories;
    }

    public FileCompletionModel() {
        this(false);
    }

    public void setCompleteHiddenFiles(boolean complete) {
        this.completeHiddenFiles = complete;
    }

    public void setCompleteDirectoriesOnly(boolean complete) {
        this.completeOnlyDirectories = complete;
    }

    public boolean complete(String prefix) {
        File parent;
        this.removeAllElements();
        File file = new File(prefix);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles(this.dirFilter);
            int i = 0;
            while (files != null && i < files.length) {
                this.addElement(files[i].getAbsolutePath());
                ++i;
            }
        }
        if ((parent = file.getParentFile()) != null) {
            File[] files = parent.listFiles(new PrefixFileFilter(file.getName()));
            int i = 0;
            while (files != null && i < files.length) {
                this.addElement(files[i].getAbsolutePath());
                ++i;
            }
        }
        return this.getSize() > 0;
    }

    public String completeUniquePrefix(String prefix) {
        File file = new File(prefix);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles(this.dirFilter);
            StringBuilder sb = new StringBuilder(FileHelper.appendSeparator(file.getAbsolutePath()));
            int i = 0;
            while (this.matches(files, i)) {
                sb.append(files[0].getName().charAt(i));
                ++i;
            }
            return sb.toString();
        }
        if (file.getParentFile() != null) {
            File[] files = file.getParentFile().listFiles(new PrefixFileFilter(file.getName()));
            StringBuilder sb = new StringBuilder(FileHelper.appendSeparator(file.getParentFile().getAbsolutePath()));
            int i = 0;
            while (this.matches(files, i)) {
                sb.append(files[0].getName().charAt(i));
                ++i;
            }
            return sb.toString();
        }
        return prefix;
    }

    private boolean matches(File[] files, int index) {
        if (files == null || files.length == 0) {
            return false;
        }
        if (files.length == 1) {
            return index < files[0].getName().length();
        }
        int i = 0;
        while (i < files.length - 1) {
            if (files[i].getName().length() == index || files[i + 1].getName().length() == index) {
                return false;
            }
            if (files[i].getName().charAt(index) != files[i + 1].getName().charAt(index)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        public boolean accept(File pathname) {
            return !(FileCompletionModel.this.completeOnlyDirectories && !pathname.isDirectory() || !FileCompletionModel.this.completeHiddenFiles && pathname.isHidden());
        }
    }

    private class PrefixFileFilter
    extends DirectoryFileFilter {
        private String prefix;

        public PrefixFileFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File pathname) {
            return super.accept(pathname) && pathname.getName().startsWith(this.prefix);
        }
    }
}

