/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.completion.AbstractCompletionMode;
import org.xnap.commons.gui.completion.CompletionPopup;
import org.xnap.commons.gui.util.GUIHelper;

public class DropDownListCompletionMode
extends AbstractCompletionMode {
    protected CompletionPopup popup = new CompletionPopup();
    protected DocumentListener listener = new DocumentHandler();
    private static Log logger = LogFactory.getLog(DropDownListCompletionMode.class);
    static /* synthetic */ Class class$0;

    protected void enable() {
        this.popup.enablePopup(this.getCompletion());
        this.getTextComponent().getDocument().addDocumentListener(this.listener);
    }

    public void disable() {
        this.popup.disablePopup();
        this.getTextComponent().getDocument().removeDocumentListener(this.listener);
    }

    protected void showPopup() {
        if (!this.getTextComponent().isShowing()) {
            return;
        }
        if (this.getCompletion().isWholeTextCompletion()) {
            GUIHelper.showPopupMenu(this.popup, this.getTextComponent(), 0, this.getTextComponent().getHeight());
        } else {
            try {
                int pos = this.getTextComponent().getCaretPosition() + 1;
                Rectangle r = this.getTextComponent().modelToView(pos);
                Point p = r.getLocation();
                GUIHelper.showPopupMenu(this.popup, this.getTextComponent(), p.x, p.y + r.height);
            }
            catch (BadLocationException ble) {
                logger.debug("bad location", ble);
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            if (e.getLength() == 1 && DropDownListCompletionMode.this.getModel().complete(DropDownListCompletionMode.this.getText())) {
                DropDownListCompletionMode.this.showPopup();
            } else {
                DropDownListCompletionMode.this.popup.setVisible(false);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (e.getLength() == 1 && DropDownListCompletionMode.this.getModel().complete(DropDownListCompletionMode.this.getText())) {
                DropDownListCompletionMode.this.showPopup();
            } else {
                DropDownListCompletionMode.this.popup.setVisible(false);
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

