/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;
import org.xnap.commons.gui.completion.CompletionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompletionModel
extends DefaultComboBoxModel
implements CompletionModel {
    private CharNode root = null;

    public DefaultCompletionModel() {
    }

    public DefaultCompletionModel(Object[] items) {
        this(items, false);
    }

    public DefaultCompletionModel(Object[] items, boolean sorted) {
        this.insert(items, sorted);
    }

    @Override
    public boolean complete(String prefix) {
        CharNode node;
        this.removeAllElements();
        if (prefix.length() != 0 && (node = this.search(prefix)) != null) {
            if (node.obj != null) {
                this.addElement(node.obj);
            }
            this.collectElements(node.eqkid);
        }
        return this.getSize() > 0;
    }

    @Override
    public String completeUniquePrefix(String prefix) {
        CharNode node = this.search(prefix);
        if (node != null && node.obj == null && node.eqkid != null) {
            StringBuilder sb = new StringBuilder(prefix);
            node = node.eqkid;
            while (node != null && node.lokid == null && node.hikid == null) {
                sb.append(node.splitchar);
                if (node.obj != null) break;
                node = node.eqkid;
            }
            return sb.toString();
        }
        return prefix;
    }

    public void insert(Object object) {
        char[] key = object.toString().toCharArray();
        this.root = this.insert(this.root, key, 0, object);
    }

    public void insert(Object[] items, boolean sorted) {
        if (!sorted) {
            Arrays.sort(items, new StringComparator());
        }
        this.insert(items, 0, items.length);
    }

    public void insert(Object[] items) {
        this.insert(items, false);
    }

    public void remove(Object object) {
        CharNode node = this.root;
        int index = 0;
        Stack<CharNode> stack = new Stack<CharNode>();
        String prefix = object.toString();
        int prefixLength = prefix.length();
        while (node != null && index < prefixLength) {
            stack.push(node);
            char c = prefix.charAt(index);
            if (c < node.splitchar) {
                node = node.lokid;
                continue;
            }
            if (c == node.splitchar) {
                if (index == prefixLength - 1) break;
                node = node.eqkid;
                ++index;
                continue;
            }
            node = node.hikid;
        }
        if (node != null && node.obj.equals(object)) {
            node.obj = null;
            stack.pop();
            while (node.obj == null && node.lokid == null && node.hikid == null && !stack.empty()) {
                node.eqkid = null;
                node = (CharNode)stack.pop();
            }
        }
    }

    public Object[] toArray() {
        LinkedList<Object> list = new LinkedList<Object>();
        this.collectElements(this.root, list);
        return list.toArray();
    }

    public void clear() {
        this.root = null;
    }

    private void collectElements(CharNode node, Collection<Object> col) {
        if (node != null) {
            this.collectElements(node.lokid, col);
            if (node.obj != null) {
                col.add(node.obj);
            }
            this.collectElements(node.eqkid, col);
            this.collectElements(node.hikid, col);
        }
    }

    private void collectElements(CharNode node) {
        if (node != null) {
            this.collectElements(node.lokid);
            if (node.obj != null) {
                this.addElement(node.obj);
            }
            this.collectElements(node.eqkid);
            this.collectElements(node.hikid);
        }
    }

    private void insert(Object[] items, int left, int right) {
        if (left < right) {
            int m = left + (int)Math.floor((right - left) / 2);
            this.insert(items[m]);
            this.insert(items, left, m);
            this.insert(items, m + 1, right);
        }
    }

    private CharNode insert(CharNode node, char[] key, int index, Object object) {
        if (node == null) {
            node = new CharNode(key[index]);
            if (index == key.length - 1) {
                node.obj = object;
            }
        }
        if (key[index] < node.splitchar) {
            node.lokid = this.insert(node.lokid, key, index, object);
        } else if (key[index] == node.splitchar) {
            if (++index < key.length) {
                node.eqkid = this.insert(node.eqkid, key, index, object);
            } else {
                node.obj = object;
            }
        } else {
            node.hikid = this.insert(node.hikid, key, index, object);
        }
        return node;
    }

    private CharNode search(String prefix) {
        CharNode node = this.root;
        int index = 0;
        int prefixLength = prefix.length();
        while (node != null && index < prefixLength) {
            char c = prefix.charAt(index);
            if (c < node.splitchar) {
                node = node.lokid;
                continue;
            }
            if (c == node.splitchar) {
                if (index == prefixLength - 1) {
                    return node;
                }
                node = node.eqkid;
                ++index;
                continue;
            }
            node = node.hikid;
        }
        return node;
    }

    private class CharNode {
        public char splitchar;
        public CharNode lokid;
        public CharNode eqkid;
        public CharNode hikid;
        public Object obj;

        public CharNode(char value) {
            this.splitchar = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringComparator
    implements Comparator<Object> {
        StringComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            return obj1.toString().compareTo(obj2.toString());
        }
    }
}

