/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.completion.Completion;

public class CompletionPopup
extends JPopupMenu {
    private Completion completion;
    private JList list = new JList();
    private KeyListener keyListener = new KeyHandler();
    private FocusListener focusListener = new FocusHandler();
    private ComponentListener componentListener = new SizeHandler();
    private PropertyChangeListener propertyListener = new PropertyChangeHandler();
    private static Log logger = LogFactory.getLog(CompletionPopup.class);
    static /* synthetic */ Class class$0;

    public CompletionPopup() {
        this.list.setVisibleRowCount(4);
        this.list.setSelectionMode(0);
        JScrollPane jsp = new JScrollPane(this.list);
        this.add(jsp);
        this.list.setFocusable(false);
        jsp.setFocusable(false);
        this.setFocusable(false);
        this.list.addMouseListener(new MouseHandler());
    }

    public void enablePopup(Completion comp) {
        this.completion = comp;
        this.applyComponentOrientation(this.completion.getTextComponent().getComponentOrientation());
        this.completion.getTextComponent().addKeyListener(this.keyListener);
        this.completion.getTextComponent().addFocusListener(this.focusListener);
        this.completion.getTextComponent().addPropertyChangeListener("componentOrientation", this.propertyListener);
        this.list.setModel(this.completion.getModel());
        if (this.completion.isWholeTextCompletion()) {
            this.setPreferredSize(new Dimension(this.completion.getTextComponent().getWidth(), this.getPreferredSize().height));
            this.completion.getTextComponent().addComponentListener(this.componentListener);
        }
    }

    public void disablePopup() {
        this.completion.getTextComponent().removeKeyListener(this.keyListener);
        this.completion.getTextComponent().removeFocusListener(this.focusListener);
        this.completion.getTextComponent().removePropertyChangeListener("componentOrientation", this.propertyListener);
        if (this.completion.isWholeTextCompletion()) {
            this.completion.getTextComponent().removeComponentListener(this.componentListener);
        }
    }

    private void selectNextCompletion() {
        if (this.completion.getModel().getSize() > 0) {
            int cur = (this.list.getSelectedIndex() + 1) % this.completion.getModel().getSize();
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    private void selectPreviousCompletion() {
        if (this.completion.getModel().getSize() > 0) {
            int cur = this.list.getSelectedIndex() == -1 ? 0 : this.list.getSelectedIndex();
            cur = cur == 0 ? this.completion.getModel().getSize() - 1 : cur - 1;
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    JList getList() {
        return this.list;
    }

    public class SizeHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            CompletionPopup.this.setPreferredSize(new Dimension(CompletionPopup.this.completion.getTextComponent().getWidth(), CompletionPopup.this.getPreferredSize().height));
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            int modifiers = e.getModifiers();
            if (CompletionPopup.this.isVisible()) {
                if (code == 40) {
                    CompletionPopup.this.selectNextCompletion();
                    e.consume();
                } else if (code == 38) {
                    CompletionPopup.this.selectPreviousCompletion();
                    e.consume();
                } else if (code == 10) {
                    if (CompletionPopup.this.list.getSelectedValue() != null) {
                        CompletionPopup.this.completion.setText(CompletionPopup.this.list.getSelectedValue().toString());
                        e.consume();
                    }
                    CompletionPopup.this.setVisible(false);
                } else if (code == 27) {
                    CompletionPopup.this.setVisible(false);
                    e.consume();
                }
            }
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                CompletionPopup.this.setVisible(false);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            CompletionPopup.this.completion.setText(CompletionPopup.this.list.getSelectedValue().toString());
            CompletionPopup.this.setVisible(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ComponentOrientation o = (ComponentOrientation)evt.getNewValue();
            CompletionPopup.this.applyComponentOrientation(o);
        }
    }
}

