/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.CompletionMode;
import org.xnap.commons.gui.completion.CompletionModeFactory;
import org.xnap.commons.gui.completion.CompletionModeListener;
import org.xnap.commons.gui.completion.GlobalDefaultCompletionMode;
import org.xnap.commons.gui.util.IconHelper;

public class CompletionModeMenu
extends JMenu {
    private Completion completion;
    private ButtonGroup completionGroup = new ButtonGroup();
    static /* synthetic */ Class class$0;

    public CompletionModeMenu(Completion comp) {
        super(CompletionModeFactory.I18N.tr("Text Completion"));
        CompletionModeFactory.CompletionModeInfo[] infos;
        this.setIcon(IconHelper.getMenuIcon("completion.png"));
        this.completion = comp;
        CompletionModeFactory.CompletionModeInfo[] completionModeInfoArray = infos = CompletionModeFactory.getInstalledCompletionModes();
        int n = 0;
        int n2 = completionModeInfoArray.length;
        while (n < n2) {
            CompletionModeFactory.CompletionModeInfo info = completionModeInfoArray[n];
            this.addMode(info);
            ++n;
        }
        this.addSeparator();
        this.addMode(new CompletionModeFactory.CompletionModeInfo(CompletionModeFactory.I18N.tr("Application Default"), GlobalDefaultCompletionMode.class.getName()));
        this.completion.addCompletionModeListener(new CompletionModeChangeHandler());
    }

    private void addMode(CompletionModeFactory.CompletionModeInfo info) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(new CompletionModeAction(info));
        this.completionGroup.add(item);
        this.add(item);
        if (info.getClassName().equals(this.completion.getMode().getClass().getName())) {
            item.setSelected(true);
        }
    }

    private void setMode(CompletionModeFactory.CompletionModeInfo info) {
        try {
            CompletionMode mode = CompletionModeFactory.createCompletionMode(info);
            this.completion.setMode(mode);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CompletionModeAction
    extends AbstractAction {
        CompletionModeFactory.CompletionModeInfo info;

        public CompletionModeAction(CompletionModeFactory.CompletionModeInfo info) {
            this.info = info;
            this.putValue("Name", info.getName());
            this.putValue("ActionCommandKey", info.getClassName());
        }

        public void actionPerformed(ActionEvent e) {
            CompletionModeMenu.this.setMode(this.info);
        }
    }

    private class CompletionModeChangeHandler
    implements CompletionModeListener {
        CompletionModeChangeHandler() {
        }

        public void modeChanged(Class oldMode, Class newMode) {
            Enumeration<AbstractButton> e = CompletionModeMenu.this.completionGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton b = e.nextElement();
                Action a = b.getAction();
                if (a == null || !a.getValue("ActionCommandKey").equals(newMode.getName())) continue;
                b.setSelected(true);
                return;
            }
        }
    }
}

