/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xnap.commons.gui.completion.AutomaticCompletionMode;
import org.xnap.commons.gui.completion.AutomaticDropDownCompletionMode;
import org.xnap.commons.gui.completion.CompletionMode;
import org.xnap.commons.gui.completion.DropDownListCompletionMode;
import org.xnap.commons.gui.completion.EmacsCompletionMode;
import org.xnap.commons.gui.completion.ManualCompletionMode;
import org.xnap.commons.gui.completion.NoCompletionMode;
import org.xnap.commons.gui.completion.ShortAutomaticCompletionMode;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CompletionModeFactory {
    static final I18n I18N = I18nFactory.getI18n(CompletionModeFactory.class);
    private static CompletionModeInfo[] infos = new CompletionModeInfo[]{new CompletionModeInfo(I18N.tr("No Completion"), NoCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Automatic"), AutomaticCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Automatic Dropdown"), AutomaticDropDownCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Dropdown List"), DropDownListCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Emacs Completion"), EmacsCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Manual"), ManualCompletionMode.class.getName()), new CompletionModeInfo(I18N.tr("Short Automatic"), ShortAutomaticCompletionMode.class.getName())};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static CompletionModeInfo[] getInstalledCompletionModes() {
        CompletionModeInfo[] result = new CompletionModeInfo[infos.length];
        System.arraycopy(infos, 0, result, 0, result.length);
        return result;
    }

    public static CompletionModeInfo getCompletionModeInfoByClassName(String className) {
        CompletionModeInfo[] completionModeInfoArray = infos;
        int n = 0;
        int n2 = completionModeInfoArray.length;
        while (n < n2) {
            CompletionModeInfo info = completionModeInfoArray[n];
            if (info.getClassName().equals(className)) {
                return info;
            }
            ++n;
        }
        return null;
    }

    public static void installCompletionMode(CompletionModeInfo info) {
        CompletionModeInfo[] newInfos = new CompletionModeInfo[infos.length + 1];
        System.arraycopy(infos, 0, newInfos, 0, infos.length);
        newInfos[CompletionModeFactory.infos.length] = info;
        infos = newInfos;
    }

    public static CompletionMode createCompletionMode(CompletionModeInfo info) throws ClassNotFoundException, NoSuchMethodException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return CompletionModeFactory.createCompletionMode(info.getClassName());
    }

    public static CompletionMode createCompletionMode(String className) throws ClassNotFoundException, NoSuchMethodException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        if (obj instanceof CompletionMode) {
            return (CompletionMode)obj;
        }
        throw new IllegalArgumentException("Set completion mode is not a CompetionMode");
    }

    public static class CompletionModeInfo {
        private String name;
        private String className;

        public CompletionModeInfo(String name, String className) {
            if (name == null) {
                throw new NullPointerException("name must not be null");
            }
            if (className == null) {
                throw new NullPointerException("className must not be null");
            }
            this.name = name;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.name;
        }
    }
}

