/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.completion;

import java.text.BreakIterator;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.completion.CompletionMode;
import org.xnap.commons.gui.completion.CompletionModeListener;
import org.xnap.commons.gui.completion.CompletionModel;
import org.xnap.commons.gui.completion.DefaultCompletionModel;
import org.xnap.commons.gui.completion.GlobalDefaultCompletionMode;

public class Completion {
    private static Log logger = LogFactory.getLog(Completion.class);
    private CompletionModel model;
    private CompletionMode mode;
    private JTextComponent jtc;
    private boolean wholeText;
    private boolean enabled = true;
    private BreakIterator wordIterator = null;
    private ArrayList<CompletionModeListener> listeners = new ArrayList();
    static /* synthetic */ Class class$0;

    public Completion(JTextComponent textComponent, CompletionModel model, boolean wholeText) {
        if (textComponent == null) {
            throw new NullPointerException("textComponent must not be null");
        }
        this.jtc = textComponent;
        this.model = model;
        this.wholeText = wholeText;
        this.mode = new GlobalDefaultCompletionMode();
        this.mode.enable(this);
    }

    public Completion(JTextComponent textComponent, boolean wholeText) {
        this(textComponent, new DefaultCompletionModel(), wholeText);
    }

    public Completion(JTextComponent textComponent, CompletionModel model) {
        this(textComponent, model, true);
    }

    public Completion(JTextComponent textComponent) {
        this(textComponent, true);
    }

    public void setMode(CompletionMode newMode) {
        Class<?> oldMode = this.mode.getClass();
        if (this.enabled) {
            this.mode.disable();
        }
        this.mode = newMode;
        if (this.enabled) {
            this.mode.enable(this);
        }
        this.fireModeChanged(oldMode, this.mode.getClass());
    }

    public void setModel(CompletionModel model) {
        this.mode.disable();
        this.model = model;
        if (this.enabled) {
            this.mode.enable(this);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.mode.enable(this);
        } else {
            this.mode.disable();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CompletionModel getModel() {
        return this.model;
    }

    public CompletionMode getMode() {
        return this.mode;
    }

    public JTextComponent getTextComponent() {
        return this.jtc;
    }

    public final boolean isWholeTextCompletion() {
        return this.wholeText;
    }

    public void setText(String text) {
        this.setText(text, text.length(), text.length());
    }

    protected void setText(String text, int selectionStart, int selectionEnd) {
        if (this.isWholeTextCompletion()) {
            this.jtc.setText(text);
            this.jtc.setCaretPosition(selectionStart);
            this.jtc.moveCaretPosition(selectionEnd);
        } else {
            int offs = -1;
            try {
                offs = Utilities.getPreviousWord(this.jtc, this.jtc.getCaretPosition());
            }
            catch (BadLocationException e) {
                logger.debug(e);
            }
            this.jtc.moveCaretPosition(offs);
            this.jtc.replaceSelection(text);
            this.jtc.setCaretPosition(offs + selectionStart);
            this.jtc.moveCaretPosition(offs + selectionEnd);
        }
    }

    private String getPreviousWord() {
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        int start = this.jtc.getCaretPosition();
        try {
            String ret;
            start = Utilities.getPreviousWord(this.jtc, start);
            int length = this.jtc.getCaretPosition() - start;
            if (length > 1) {
                String ret2 = this.jtc.getText(start, length);
                this.wordIterator.setText(ret2);
                if (!this.wordIterator.isBoundary(length - 1)) {
                    return ret2;
                }
            } else if (length == 1 && Character.isLetterOrDigit((ret = this.jtc.getText(start, length)).charAt(0))) {
                return ret;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    public String getText() {
        if (this.wholeText) {
            return this.jtc.getText();
        }
        return this.getPreviousWord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionModeListener(CompletionModeListener l) {
        ArrayList<CompletionModeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletionModeListener(CompletionModeListener l) {
        ArrayList<CompletionModeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModeChanged(Class oldMode, Class newMode) {
        CompletionModeListener[] array;
        ArrayList<CompletionModeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            array = this.listeners.toArray(new CompletionModeListener[0]);
        }
        int i = array.length - 1;
        while (i >= 0) {
            array[i].modeChanged(oldMode, newMode);
            --i;
        }
    }
}

