/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.xnap.commons.gui.ToolBarButton;
import org.xnap.commons.gui.ToolBarToggleButton;
import org.xnap.commons.gui.action.ToggleAction;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractXNapAction
extends AbstractAction {
    public static final String ICON_FILENAME = "XNapIcon";

    public void setEnabledLater(final boolean enabled) {
        Runnable runner = new Runnable(){

            public void run() {
                AbstractXNapAction.this.setEnabled(enabled);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected String tr(String text) {
        I18n i18n = I18nFactory.getI18n(this.getClass());
        return i18n.tr(text);
    }

    protected String tr(String text, Object ... objects) {
        I18n i18n = I18nFactory.getI18n(this.getClass());
        return i18n.tr(text, objects);
    }

    public static Icon getIcon(AbstractButton button, String filename) {
        if (button instanceof JCheckBox || button instanceof JCheckBoxMenuItem) {
            return null;
        }
        if (button instanceof ToolBarButton || button instanceof ToolBarToggleButton) {
            return IconHelper.getToolBarIcon(filename);
        }
        if (button instanceof JButton || button instanceof JToggleButton) {
            return IconHelper.getButtonIcon(filename);
        }
        if (button instanceof JMenuItem) {
            return IconHelper.getMenuIcon(filename);
        }
        return null;
    }

    public static void initialize(AbstractButton button, Action action) {
        String filename = (String)action.getValue(ICON_FILENAME);
        button.setIcon(AbstractXNapAction.getIcon(button, filename != null ? filename : "does-not-exist"));
        if (action instanceof ToggleAction) {
            button.setSelected(((ToggleAction)action).isSelected());
        }
        action.addPropertyChangeListener(new ActionPropertyListener(button));
    }

    private static class ActionPropertyListener
    implements PropertyChangeListener {
        private AbstractButton button;

        public ActionPropertyListener(AbstractButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("Selected")) {
                this.button.setSelected((Boolean)e.getNewValue());
            } else if (e.getPropertyName().equals(AbstractXNapAction.ICON_FILENAME)) {
                String filename = (String)e.getNewValue();
                this.button.setIcon(AbstractXNapAction.getIcon(this.button, filename));
            }
        }
    }
}

