/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JToggleButton;
import org.xnap.commons.gui.action.ToggleAction;

public class ToolBarToggleButton
extends JToggleButton {
    private boolean showBorder;
    private boolean showMenuHint;

    public ToolBarToggleButton(ToggleAction action, boolean showMenuHint) {
        super(action);
        this.showMenuHint = showMenuHint;
        this.setContentAreaFilled(false);
        this.setText(null);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.putClientProperty("hideActionText", Boolean.TRUE);
    }

    public boolean isMouseOver() {
        return this.showBorder;
    }

    protected void paintBorder(Graphics g) {
        if (this.showBorder || this.isSelected()) {
            super.paintBorder(g);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.showMenuHint) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(Color.black);
            int i = 0;
            while (i < 4) {
                g.drawLine(w - 8 - i, h - 3 - i, w - 8 + i, h - 3 - i);
                ++i;
            }
            g.drawLine(w - 8 - 4, h - 3 - 4, w - 8 + 4, h - 3 - 4);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 504) {
            this.showBorder = true;
            this.setContentAreaFilled(true);
            this.repaint();
        } else if (e.getID() == 505) {
            this.showBorder = false;
            this.setContentAreaFilled(false);
            this.repaint();
        }
    }
}

