/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ThinEtchedBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;

    public ThinEtchedBorder(int etchType) {
        this.etchType = etchType;
    }

    public ThinEtchedBorder() {
        this(1);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(this.etchType == 1 ? c.getBackground().darker() : c.getBackground().brighter());
        g.drawLine(0, h - 2, w - 1, h - 2);
        g.setColor(this.etchType == 1 ? c.getBackground().brighter() : c.getBackground().darker());
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }
}

