/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TextFieldMenu
extends JMenu {
    private static I18n i18n = I18nFactory.getI18n(TextFieldMenu.class);
    public static final Action cutAction = new CutAction();
    public static final Action copyAction = new CopyAction();
    public static final Action pasteAction = new PasteAction();
    public static final Action selectAllAction = new SelectAllAction();
    public static final Action clearAction = new ClearAction();
    static /* synthetic */ Class class$0;

    public TextFieldMenu() {
        super(i18n.tr("Edit"));
        this.add(Builder.createMenuItem(cutAction));
        this.add(Builder.createMenuItem(copyAction));
        this.add(Builder.createMenuItem(pasteAction));
        this.add(Builder.createMenuItem(clearAction));
        this.addSeparator();
        this.add(Builder.createMenuItem(selectAllAction));
    }

    public static class SelectAllAction
    extends TextAction {
        public SelectAllAction() {
            super("select-all");
            this.putValue("Name", i18n.tr("Select All"));
            this.putValue("ShortDescription", i18n.tr("Selects all text"));
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null) {
                Document doc = target.getDocument();
                target.setCaretPosition(0);
                target.moveCaretPosition(doc.getLength());
            }
        }
    }

    public static class ClearAction
    extends TextAction {
        public ClearAction() {
            super("clear");
            this.putValue("Name", i18n.tr("Clear"));
            this.putValue("ShortDescription", i18n.tr("Deletes all text"));
            this.putValue("XNapIcon", "editclear.png");
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null) {
                target.setText("");
            }
        }
    }

    public static class CopyAction
    extends DefaultEditorKit.CopyAction {
        public CopyAction() {
            this.putValue("Name", i18n.tr("Copy"));
            this.putValue("ShortDescription", i18n.tr("Copies selected text to clipboard"));
            this.putValue("XNapIcon", "editcopy.png");
        }
    }

    public static class CutAction
    extends DefaultEditorKit.CutAction {
        public CutAction() {
            this.putValue("Name", i18n.tr("Cut"));
            this.putValue("ShortDescription", i18n.tr("Moves selected text to clipboard"));
            this.putValue("XNapIcon", "editcut.png");
        }
    }

    public static class PasteAction
    extends DefaultEditorKit.PasteAction {
        public PasteAction() {
            this.putValue("Name", i18n.tr("Paste"));
            this.putValue("ShortDescription", i18n.tr("Pastes clipboard contents"));
            this.putValue("XNapIcon", "editpaste.png");
        }
    }
}

