/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.xnap.commons.gui.util.GUIHelper;

public class SplashWindow
extends JWindow {
    private static SplashWindow instance = null;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel imageLabel;
    private static Object lock = new Object();

    private SplashWindow(String text, Icon icon) {
        Color bg = UIManager.getColor("TextField.background");
        Color fg = UIManager.getColor("TextField.foreground");
        ContainerBox box = new ContainerBox(1);
        this.setBackground(bg);
        this.getContentPane().setBackground(bg);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)box, "Center");
        this.imageLabel = new JLabel(text);
        this.imageLabel.setForeground(fg);
        this.imageLabel.setIcon(icon);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setVerticalTextPosition(3);
        this.imageLabel.setAlignmentX(0.5f);
        box.add(this.imageLabel);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setBackground(Color.white);
        this.progressBar.setBorder(GUIHelper.createEmptyBorder(5));
        this.progressBar.setAlignmentX(0.5f);
        box.add(this.progressBar);
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setForeground(fg);
        this.statusLabel.setFont(new Font("Dialog", 0, 10));
        this.statusLabel.setHorizontalTextPosition(0);
        this.statusLabel.setAlignmentX(0.5f);
        box.add(this.statusLabel);
        this.pack();
        this.centerOnScreen();
        this.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mousePressed(MouseEvent event) {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
    }

    public void centerOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
    }

    public static SplashWindow createInstance(String text, Icon icon) {
        if (instance == null) {
            instance = new SplashWindow(text, icon);
        }
        return instance;
    }

    public static void showSplashWindow(String text, Icon icon, long timeout) {
        SplashWindow.createInstance(text, icon).show(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSplashWindow() {
        if (instance != null) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
    }

    public static SplashWindow getInstance() {
        return instance;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public JLabel getImageLabel() {
        return this.imageLabel;
    }

    public static int getProgress() {
        return instance != null ? SplashWindow.instance.progressBar.getValue() : 0;
    }

    public static void incProgress(int delta, String text) {
        if (instance != null) {
            SplashWindow.incProgress(delta);
            SplashWindow.setText(text);
        }
    }

    public static void incProgress(int delta) {
        if (instance != null) {
            SplashWindow.instance.progressBar.setValue(SplashWindow.instance.progressBar.getValue() + delta);
        }
    }

    public static void setProgress(int progress, String text) {
        SplashWindow.setProgress(progress);
        SplashWindow.setText(text);
    }

    public static void setProgress(int newValue) {
        if (instance != null) {
            SplashWindow.instance.progressBar.setValue(newValue);
        }
    }

    public static void setText(String newValue) {
        if (instance != null) {
            SplashWindow.instance.statusLabel.setText(newValue);
        }
    }

    public void show(long timeout) {
        Thread t = new Thread((Runnable)new CloseRunner(timeout), "SplashWindowWaiter");
        t.start();
        this.setVisible(true);
    }

    public static void updateComponentTree() {
        if (instance != null) {
            SwingUtilities.updateComponentTreeUI(instance);
        }
    }

    static /* synthetic */ SplashWindow access$1() {
        return instance;
    }

    static /* synthetic */ void access$2(SplashWindow splashWindow) {
        instance = splashWindow;
    }

    public static class CloseRunner
    implements Runnable {
        long timeout;

        public CloseRunner(long timeout) {
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = lock;
                synchronized (object) {
                    if (this.timeout > 0L) {
                        lock.wait(this.timeout);
                    } else {
                        lock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runnable runner = new Runnable(this){
                final /* synthetic */ CloseRunner this$1;
                {
                    this.this$1 = closeRunner;
                }

                public void run() {
                    SplashWindow.access$1().setVisible(false);
                    SplashWindow.access$1().dispose();
                    SplashWindow.access$2(null);
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    private class ContainerBox
    extends Box {
        public ContainerBox(int axis) {
            super(axis);
        }

        public void updateUI() {
            super.updateUI();
            Color bg = UIManager.getColor("TextField.background");
            Color fg = UIManager.getColor("TextField.foreground");
            SplashWindow.this.setBackground(bg);
            SplashWindow.this.getContentPane().setBackground(bg);
            SplashWindow.this.imageLabel.setForeground(fg);
            SplashWindow.this.statusLabel.setForeground(fg);
            SplashWindow.this.statusLabel.setBackground(bg);
        }
    }
}

