/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.io.ProgressMonitor;

public class ProgressDialog
extends DefaultDialog
implements ProgressMonitor {
    public static final int MAX_VALUE = 1000;
    private boolean isCancelled = false;
    private JPanel panel;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private boolean disposed = false;
    private long value;
    private long totalSteps;

    public ProgressDialog(JDialog owner, int buttons, String title) {
        super((Dialog)owner, buttons);
        this.initialize();
        this.setTitle(title);
    }

    public ProgressDialog(JFrame owner, int buttons, String title) {
        super((Frame)owner, buttons);
        this.initialize();
        this.setTitle(title);
    }

    public ProgressDialog(int buttons, String title) {
        super(buttons);
        this.initialize();
        this.setTitle(title);
    }

    public ProgressDialog(JDialog owner, String title) {
        this(owner, BUTTON_CANCEL, title);
    }

    public ProgressDialog(JFrame owner, String title) {
        this(owner, BUTTON_CANCEL, title);
    }

    public ProgressDialog(String title) {
        this(BUTTON_CANCEL, title);
    }

    public ProgressDialog(int buttons) {
        super(buttons);
        this.initialize();
    }

    public ProgressDialog(JDialog owner) {
        this(owner, BUTTON_CANCEL, null);
    }

    public ProgressDialog(JFrame owner) {
        this(owner, BUTTON_CANCEL, null);
    }

    public ProgressDialog() {
        this(BUTTON_CANCEL);
    }

    private void initialize() {
        this.setModal(true);
        this.panel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel(GUIHelper.tt("&nbsp;"));
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.panel.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(1000);
        this.progressBar.setValue(0);
        this.panel.add((Component)this.progressBar, "South");
        this.setMainComponent(this.panel);
        this.pack();
    }

    public void close() {
        this.getCancelAction().setEnabled(false);
        this.isCancelled = true;
    }

    public void done() {
        Runnable r = new Runnable(){

            public void run() {
                if (ProgressDialog.this.isVisible()) {
                    ProgressDialog.this.dispose();
                } else {
                    ProgressDialog.this.disposed = true;
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public long getValue() {
        return this.value;
    }

    public void setCancelEnabled(final boolean enabled) {
        Runnable r = new Runnable(){

            public void run() {
                ProgressDialog.this.getCancelAction().setEnabled(enabled);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setTotalSteps(long max) {
        this.totalSteps = max;
    }

    public void setValue(long value) {
        this.value = value;
        final double percent = (double)this.value / (double)this.totalSteps;
        Runnable r = new Runnable(){

            public void run() {
                ProgressDialog.this.progressBar.setValue((int)(percent * 1000.0));
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void work(long amount) {
        this.value += amount;
        final double percent = (double)this.value / (double)this.totalSteps;
        Runnable r = new Runnable(){

            public void run() {
                ProgressDialog.this.progressBar.setValue((int)(percent * 1000.0));
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setText(final String text) {
        Runnable r = new Runnable(){

            public void run() {
                ProgressDialog.this.statusLabel.setText(GUIHelper.tt(text));
                ProgressDialog.this.pack();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void showDialog() {
        if (this.disposed) {
            this.disposed = false;
            return;
        }
        super.setVisible(true);
    }

    public Component getComponent() {
        return this;
    }
}

