/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconSplitPane
extends JSplitPane {
    private JList iconList;
    private DefaultListModel iconListModel;
    private CardLayout containerLayout;
    private Container container;
    private transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$0;

    public IconSplitPane() {
        super(1);
        this.initialize();
    }

    private void initialize() {
        this.setOneTouchExpandable(true);
        this.iconList = new JList();
        this.iconListModel = new DefaultListModel();
        this.iconList.setModel(this.iconListModel);
        this.iconList.addListSelectionListener(new IconListener());
        this.iconList.setSelectionMode(0);
        this.iconList.setCellRenderer(new IconRenderer());
        JScrollPane jspIcons = new JScrollPane(this.iconList);
        jspIcons.setHorizontalScrollBarPolicy(31);
        this.add((Component)jspIcons, "left");
        this.containerLayout = new CardLayout();
        this.container = new Container();
        this.container.setLayout(this.containerLayout);
        this.add((Component)this.container, "right");
    }

    public void addTab(String description, Icon icon, Component c) {
        this.insertTab(description, icon, c, this.iconListModel.size());
    }

    public void insertTab(String description, Icon icon, Component c, int index) {
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                ((ImageIcon)icon).setDescription(description);
            }
            this.iconListModel.insertElementAt(icon, index);
        } else {
            this.iconListModel.insertElementAt(description, index);
        }
        this.container.add(c, description, index);
        this.setDividerLocation(this.iconList.getPreferredSize().width + 30);
        if (this.iconListModel.size() == 1) {
            this.iconList.setSelectedIndex(0);
        } else if (this.iconList.getSelectedIndex() >= index) {
            this.iconList.setSelectedIndex(this.iconList.getSelectedIndex() + 1);
        }
    }

    public Component[] getTabs() {
        return this.container.getComponents();
    }

    public Component getTabAt(int i) {
        return this.container.getComponents()[i];
    }

    public int getTabCount() {
        return this.container.getComponentCount();
    }

    public String getDescriptionAt(int i) {
        Object o = this.iconListModel.get(i);
        if (o != null) {
            if (o instanceof ImageIcon) {
                return ((ImageIcon)o).getDescription();
            }
            return o.toString();
        }
        return null;
    }

    public Icon getIconAt(int i) {
        Object o = this.iconListModel.get(i);
        if (o instanceof Icon) {
            return (Icon)o;
        }
        return null;
    }

    public String getTitleAt(int i) {
        return this.iconListModel.get(i).toString();
    }

    public void setIconAt(int i, Icon icon) {
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                ((ImageIcon)icon).setDescription(this.getDescriptionAt(i));
            }
            this.iconListModel.set(i, icon);
        }
    }

    public int getSelectedIndex() {
        return this.iconList.getSelectedIndex();
    }

    public void setSelectedComponent(Component c) {
        int i = this.indexOfComponent(c);
        if (i != -1) {
            this.iconList.setSelectedIndex(i);
        }
    }

    public int indexOfComponent(Component c) {
        int count = this.container.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.container.getComponent(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(Component c) {
        if (this.container == null) {
            return;
        }
        int i = this.indexOfComponent(c);
        if (i != -1) {
            this.removeTabAt(i);
        }
    }

    public void removeTabAt(int i) {
        if (i == this.iconList.getSelectedIndex()) {
            this.iconList.setSelectedIndex(0);
        }
        this.container.remove(i);
        this.iconListModel.remove(i);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public Component getSelectedComponent() {
        return this.container.getComponent(this.iconList.getSelectedIndex());
    }

    private class IconListener
    implements ListSelectionListener {
        IconListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = IconSplitPane.this.iconList.getSelectedIndex();
            if (index != -1) {
                String description = null;
                Object o = IconSplitPane.this.iconListModel.elementAt(index);
                if (o instanceof ImageIcon) {
                    description = ((ImageIcon)o).getDescription();
                } else if (o instanceof String) {
                    description = (String)o;
                }
                IconSplitPane.this.containerLayout.show(IconSplitPane.this.container, description);
                IconSplitPane.this.fireStateChanged();
            }
        }
    }

    private class IconRenderer
    extends JLabel
    implements ListCellRenderer {
        public IconRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(null);
            this.setIcon(null);
            if (value instanceof ImageIcon) {
                ImageIcon icon = (ImageIcon)value;
                this.setText(icon.getDescription());
                this.setIcon(icon);
            } else if (value instanceof String) {
                this.setText((String)value);
            }
            return this;
        }
    }
}

