/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.FileCompletionModel;
import org.xnap.commons.gui.dnd.DefaultTextFieldFileTransferHandler;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FileChooserPanel
extends JPanel {
    private static I18n i18n = I18nFactory.getI18n(FileChooserPanel.class);
    private JTextField filenameTextField;
    private FileChooserAction fileChooserAction;
    private Component dialogParent = this;
    private Completion completion;
    private JFileChooser chooser;
    static /* synthetic */ Class class$0;

    public FileChooserPanel(File file, int columns) {
        this.setLayout(new BoxLayout(this, 2));
        this.filenameTextField = new JTextField(columns);
        this.filenameTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.filenameTextField.getPreferredSize().height));
        DefaultTextFieldFileTransferHandler.install(this.filenameTextField);
        this.add(this.filenameTextField);
        this.completion = Builder.addCompletion((JTextComponent)this.filenameTextField, new FileCompletionModel());
        this.add(Box.createHorizontalStrut(4));
        this.fileChooserAction = new FileChooserAction();
        this.add(Builder.createIconButton(this.fileChooserAction));
        this.setFile(file);
    }

    public FileChooserPanel(int columns) {
        this(null, columns);
    }

    protected void fileSelected(File file) {
    }

    public File getFile() {
        return this.filenameTextField.getText().length() != 0 ? new File(this.filenameTextField.getText()) : null;
    }

    public JFileChooser getFileChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setApproveButtonText(i18n.tr("OK"));
            this.chooser.setDialogTitle(i18n.tr("Choose File"));
        }
        return this.chooser;
    }

    public void setFile(File file) {
        this.filenameTextField.setText(file != null ? file.getAbsolutePath() : "");
    }

    public void setFileChooser(JFileChooser chooser) {
        this.chooser = chooser;
    }

    public String getFilename() {
        return this.filenameTextField.getText();
    }

    public void setFilename(String filename) {
        this.filenameTextField.setText(filename);
    }

    public JTextField getTextField() {
        return this.filenameTextField;
    }

    public Completion getCompletion() {
        return this.completion;
    }

    public Action getFileChooserAction() {
        return this.fileChooserAction;
    }

    public Component getDialogParent() {
        return this.dialogParent;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTextField().setEnabled(enabled);
        this.getFileChooserAction().setEnabled(enabled);
    }

    public void setDialogParent(Component dialogParent) {
        this.dialogParent = dialogParent;
    }

    protected boolean showChooser() {
        this.getFileChooser().setSelectedFile(this.getFile());
        if (this.getFileChooser().showSaveDialog(this.getDialogParent()) == 0) {
            File file = this.chooser.getSelectedFile();
            this.setFile(file);
            return true;
        }
        return false;
    }

    private class FileChooserAction
    extends AbstractXNapAction {
        public FileChooserAction() {
            this.putValue("XNapIcon", "fileopen.png");
            this.putValue("ShortDescription", i18n.tr("Choose a file"));
        }

        public void actionPerformed(ActionEvent event) {
            if (FileChooserPanel.this.showChooser()) {
                FileChooserPanel.this.fileSelected(FileChooserPanel.this.getFile());
            }
        }
    }
}

