/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.action.AbstractToggleAction;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.util.UncaughtExceptionManager;

public class ErrorDialog
extends DefaultDialog {
    private static I18n i18n = I18nFactory.getI18n(ErrorDialog.class);
    private JPanel detailsPanel;
    private JTextArea detailsTextArea;
    private JCheckBox doNotShowExceptionAgainCheckBox;
    private JCheckBox doNotShowDialogAgainCheckBox;
    private ContinueAction continueAction = new ContinueAction();
    private DetailsAction detailsAction;
    private ExitAction exitAction = new ExitAction();
    private SendAction sendAction;
    private List<Thread> threads = new LinkedList<Thread>();
    private List<Throwable> throwables = new LinkedList<Throwable>();
    private boolean busy = false;
    private UncaughtExceptionManager exceptionManager;
    private BooleanSetting detailsVisibleSetting;
    private BooleanSetting showDialogAgainSetting;
    static /* synthetic */ Class class$0;

    ErrorDialog(String description, UncaughtExceptionManager exceptionManager, boolean showExitAction, BooleanSetting showDialogAgainSetting, BooleanSetting detailsVisibleSetting) {
        super(BUTTON_NONE);
        this.exceptionManager = exceptionManager;
        this.showDialogAgainSetting = showDialogAgainSetting;
        this.detailsVisibleSetting = detailsVisibleSetting;
        Box mainBox = Box.createVerticalBox();
        this.setMainComponent(mainBox);
        JLabel infoLabel = new JLabel(GUIHelper.tt(description), IconHelper.getIcon("error.png", 32), 10);
        infoLabel.setIconTextGap(10);
        infoLabel.setAlignmentX(0.0f);
        mainBox.add(infoLabel);
        mainBox.add(Box.createVerticalStrut(10));
        this.detailsPanel = new JPanel(new BorderLayout());
        this.detailsPanel.setAlignmentX(0.0f);
        this.updateBorder();
        this.detailsTextArea = new JTextArea(12, 80);
        this.detailsTextArea.setEditable(false);
        this.detailsTextArea.setFont(new Font("Monospaced", 0, 10));
        this.detailsPanel.add((Component)new JScrollPane(this.detailsTextArea), "Center");
        JPanel detailsButtonPanel = new JPanel(new FlowLayout(2));
        detailsButtonPanel.setAlignmentX(0.0f);
        mainBox.add(detailsButtonPanel);
        this.detailsAction = new DetailsAction(detailsVisibleSetting != null ? (Boolean)detailsVisibleSetting.getValue() : false);
        detailsButtonPanel.add(Builder.createButton(this.detailsAction));
        mainBox.add(this.detailsPanel);
        if (exceptionManager != null) {
            this.doNotShowExceptionAgainCheckBox = new JCheckBox(i18n.tr("Do not show this exception again"));
            this.doNotShowExceptionAgainCheckBox.setAlignmentX(0.0f);
            mainBox.add(this.doNotShowExceptionAgainCheckBox);
        }
        if (showDialogAgainSetting != null) {
            this.doNotShowDialogAgainCheckBox = new JCheckBox(i18n.tr("Do not show this dialog again"), (boolean)((Boolean)showDialogAgainSetting.getValue()));
            this.doNotShowDialogAgainCheckBox.setAlignmentX(0.0f);
            mainBox.add(this.doNotShowDialogAgainCheckBox);
        }
        if (exceptionManager != null) {
            this.sendAction = new SendAction();
            this.getButtonPanel().add(Builder.createButton(this.sendAction));
        }
        GUIHelper.bindEscapeKey(this.getTopPanel(), this.continueAction);
        this.getButtonPanel().add(Builder.createButton(this.continueAction));
        if (showExitAction) {
            this.getButtonPanel().add(Builder.createButton(this.exitAction));
        }
    }

    public ErrorDialog(String description) {
        this(description, null, false, null, null);
    }

    ErrorDialog() {
    }

    public void add(Thread t, Throwable e) {
        this.threads.add(t);
        this.throwables.add(e);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        e.printStackTrace(writer);
        writer.close();
        this.detailsTextArea.append(String.valueOf(out.toString()) + "\n");
        if (this.threads.size() == 1) {
            this.resetCaretPosition();
        }
        this.updateBorder();
    }

    public void close() {
        if (this.showDialogAgainSetting != null) {
            this.showDialogAgainSetting.setValue(!this.doNotShowDialogAgainCheckBox.isSelected());
        }
        if (this.detailsVisibleSetting != null) {
            this.detailsVisibleSetting.setValue(this.detailsPanel.isVisible());
        }
        if (this.exceptionManager != null && this.doNotShowExceptionAgainCheckBox.isSelected()) {
            Iterator<Throwable> it = this.throwables.iterator();
            while (it.hasNext()) {
                this.exceptionManager.addToBlacklist(it.next());
            }
        }
        this.busy = true;
        this.dispose();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void resetCaretPosition() {
        this.detailsTextArea.setCaretPosition(0);
    }

    public void updateBorder() {
        this.detailsPanel.setBorder(GUIHelper.createDefaultBorder(i18n.tr("Details - {0} Problems", new Integer(this.threads.size()))));
    }

    public static void show(Component c, String message, String title, Throwable e) {
        ErrorDialog d = new ErrorDialog(message);
        d.setTitle(title);
        d.pack();
        d.setModal(true);
        d.add(Thread.currentThread(), e);
        d.show(c);
    }

    public static void showError(Component c, String message, String title, Throwable e) {
        if (e.getLocalizedMessage() != null) {
            ErrorDialog.show(c, MessageFormat.format("{0}:<br><br>{1}", message, e.getLocalizedMessage()), title, e);
        } else {
            ErrorDialog.show(c, message, title, e);
        }
    }

    public static void showUnexpected(Component c, String message, String title, Throwable e) {
        ErrorDialog d = new ErrorDialog(message, null, true, null, null);
        d.setTitle(title);
        d.pack();
        d.setModal(true);
        d.add(Thread.currentThread(), e);
        d.show(c);
    }

    private class DetailsAction
    extends AbstractToggleAction {
        public DetailsAction(boolean visible) {
            super(visible);
            this.putValue("Name", i18n.tr("Show Details"));
            this.putValue("XNapIcon", "2downarrow.png");
            this.toggled(this.isSelected());
        }

        public void toggled(boolean visible) {
            ErrorDialog.this.detailsPanel.setVisible(visible);
            ErrorDialog.this.pack();
        }
    }

    private class ContinueAction
    extends AbstractXNapAction {
        public ContinueAction() {
            this.putValue("Name", i18n.tr("Continue"));
            this.putValue("XNapIcon", "1rightarrow.png");
        }

        public void actionPerformed(ActionEvent event) {
            ErrorDialog.this.close();
        }
    }

    private class ExitAction
    extends AbstractXNapAction {
        public ExitAction() {
            this.putValue("Name", i18n.tr("Quit"));
            this.putValue("XNapIcon", "exit.png");
            this.putValue("ShortDescription", i18n.tr("Quits the application"));
        }

        public void actionPerformed(ActionEvent event) {
            ErrorDialog.this.close();
            System.exit(1);
        }
    }

    private class SendAction
    extends AbstractXNapAction {
        public SendAction() {
            this.putValue("Name", i18n.tr("Send Report"));
            this.putValue("XNapIcon", "mail_send.png");
            this.putValue("ShortDescription", i18n.tr("Sends the details to a remote site for analysis"));
        }

        public void actionPerformed(ActionEvent event) {
            ErrorDialog.this.busy = true;
            Thread t = new Thread((Runnable)new SendWorker(), "SendFeedback");
            t.start();
        }
    }

    private class SendWorker
    implements Runnable {
        SendWorker() {
        }

        public void run() {
            ErrorDialog.this.sendAction.setEnabled(false);
            ErrorDialog.this.getCancelAction().setEnabled(false);
            ErrorDialog.this.setTitle(String.valueOf(i18n.tr("Sending Error Report")) + "...");
            Runnable runner = new Runnable(this){
                final /* synthetic */ SendWorker this$1;
                {
                    this.this$1 = sendWorker;
                }

                public void run() {
                    JOptionPane.showMessageDialog(SendWorker.access$0(this.this$1), ErrorDialog.access$0().tr("Thank you."), ErrorDialog.access$0().tr("XNap Error"), 1);
                    SendWorker.access$0(this.this$1).close();
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        public void failed(String response) {
            JOptionPane.showMessageDialog(ErrorDialog.this, i18n.tr("Could not send error report: {0}.", response), i18n.tr("XNap Error"), 0);
            ErrorDialog.this.setTitle(i18n.tr("XNap Error"));
            ErrorDialog.this.sendAction.setEnabled(true);
            ErrorDialog.this.getCancelAction().setEnabled(true);
            ErrorDialog.this.busy = false;
        }

        static /* synthetic */ ErrorDialog access$0(SendWorker sendWorker) {
            return sendWorker.ErrorDialog.this;
        }
    }
}

