/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.dnd.DefaultTreeFileTransferHandler;
import org.xnap.commons.gui.tree.FileCellRenderer;
import org.xnap.commons.gui.tree.FileNode;
import org.xnap.commons.gui.tree.FileTreeModel;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DirectoryChooser
extends DefaultDialog
implements TreeSelectionListener {
    private static final I18n i18n = I18nFactory.getI18n(DirectoryChooser.class);
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private JTree directoryTree;
    private FileTreeModel directoryTreeModel;
    private HomeAction homeAction;
    private int selectedOption;
    static /* synthetic */ Class class$0;

    public DirectoryChooser(JFrame owner) {
        super((Frame)owner, BUTTON_OKAY | BUTTON_CANCEL);
        this.initialize();
    }

    public DirectoryChooser(JDialog owner) {
        super((Dialog)owner, BUTTON_OKAY | BUTTON_CANCEL);
        this.initialize();
    }

    public DirectoryChooser() {
        super(BUTTON_OKAY | BUTTON_CANCEL);
        this.initialize();
    }

    private void initialize() {
        this.directoryTreeModel = new FileTreeModel(i18n.tr("Folders"), File.listRoots());
        this.directoryTree = new JTree(this.directoryTreeModel);
        this.directoryTree.setRootVisible(false);
        this.directoryTree.setCellRenderer(new FileCellRenderer());
        this.directoryTree.putClientProperty("JTree.lineStyle", "Angled");
        this.directoryTree.addTreeSelectionListener(this);
        this.directoryTree.setTransferHandler(new DefaultTreeFileTransferHandler());
        this.directoryTree.setDragEnabled(true);
        JScrollPane jspDirectories = new JScrollPane(this.directoryTree);
        this.homeAction = new HomeAction();
        this.getButtonPanel().add((Component)Builder.createButton(this.homeAction), 0);
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add((Component)jspDirectories, "Center");
        this.pack();
    }

    public boolean apply() {
        this.selectedOption = 1;
        return true;
    }

    public void cancelled() {
        this.selectedOption = 2;
    }

    public File getSelectedDirectory() {
        Object selectedItem = this.directoryTree.getLastSelectedPathComponent();
        return selectedItem instanceof File ? (File)selectedItem : null;
    }

    public void setSelectedDirectory(File dir) {
        LinkedList<FileNode> files = new LinkedList<FileNode>();
        File parent = dir;
        while (parent != null) {
            files.addFirst(new FileNode(parent));
            parent = parent.getParentFile();
        }
        Object[] path = new Object[files.size() + 1];
        path[0] = this.directoryTreeModel.getRoot();
        System.arraycopy(files.toArray(), 0, path, 1, path.length - 1);
        TreePath tp = new TreePath(path);
        this.directoryTree.setSelectionPath(tp);
        this.directoryTree.scrollPathToVisible(tp);
    }

    public int showChooseDialog(Component c) {
        this.setTitle(i18n.tr("Choose a Folder"));
        this.setModal(true);
        this.pack();
        this.show(c);
        return this.selectedOption;
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.getOkayAction().setEnabled(this.directoryTree.getLastSelectedPathComponent() instanceof File);
    }

    public class HomeAction
    extends AbstractXNapAction {
        public HomeAction() {
            this.putValue("Name", i18n.tr("Home"));
            this.putValue("ShortDescription", i18n.tr("Jump to home folder"));
            this.putValue("XNapIcon", "folder_home.png");
        }

        public void actionPerformed(ActionEvent event) {
            DirectoryChooser.this.setSelectedDirectory(new File(System.getProperty("user.home")));
        }
    }
}

