/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.util.FileHelper;

public class Dialogs {
    private static final I18n i18n = I18nFactory.getI18n(Dialogs.class);
    static /* synthetic */ Class class$0;

    public static boolean executeCopy(Component parent, File[] files, File target) {
        if (files != null) {
            boolean success = true;
            int i = 0;
            while (i < files.length) {
                try {
                    FileHelper.copy(files[i], new File(target, files[i].getName()));
                }
                catch (IOException e) {
                    Dialogs.showError(parent, i18n.tr("Could not copy {0} to {1}: {2}.", files[i].getAbsolutePath(), target.getAbsolutePath(), e.getLocalizedMessage()), e);
                    success = false;
                }
                ++i;
            }
            return success;
        }
        return false;
    }

    public static boolean executeMove(Component parent, File[] files, File target) {
        if (files != null) {
            boolean success = true;
            int i = 0;
            while (i < files.length) {
                try {
                    FileHelper.moveUnique(files[i], target.getAbsolutePath());
                }
                catch (IOException e) {
                    Dialogs.showError(parent, i18n.tr("Could not move {0} to {1}: {2}.", files[i].getAbsolutePath(), target.getAbsolutePath(), e.getLocalizedMessage()), e);
                    success = false;
                }
                ++i;
            }
            return success;
        }
        return false;
    }

    public static String requestInput(Component parent, String message, String title) {
        return JOptionPane.showInputDialog(parent, message, title, 3);
    }

    public static String requestPassword(Component parent, String message, String title) {
        JPasswordField passwordField = new JPasswordField();
        Object[] content = new Object[]{message, passwordField};
        if (JOptionPane.showConfirmDialog(parent, content, title, 2, 3) == 0) {
            return new String(passwordField.getPassword());
        }
        return null;
    }

    public static boolean showCloseDialog(Component parent, String message, BooleanSetting setting) {
        JCheckBox alwaysQuitCheckBox = new JCheckBox(i18n.tr("Always quit without prompting me"));
        if (setting != null) {
            alwaysQuitCheckBox.setSelected((Boolean)setting.getValue());
        }
        Object[] content = new Object[]{message, i18n.tr("Do you really want to quit?"), alwaysQuitCheckBox};
        int response = JOptionPane.showConfirmDialog(parent, content, i18n.tr("Quit"), 2);
        setting.setValue(alwaysQuitCheckBox.isSelected());
        return response == 0;
    }

    public static int showConfirmDialog(Component parent, String message, String title, int optionType, BooleanSetting setting) {
        if (setting != null && !((Boolean)setting.getValue()).booleanValue()) {
            return 0;
        }
        JCheckBox doNotAskAgainCheckBox = new JCheckBox(i18n.tr("Do not ask again"));
        JLabel messageLabel = new JLabel(GUIHelper.tt(message, 400));
        Object[] content = new Object[]{messageLabel, Box.createVerticalStrut(10), doNotAskAgainCheckBox, Box.createVerticalStrut(5)};
        int response = JOptionPane.showConfirmDialog(parent, content, title, optionType);
        if (setting != null) {
            setting.setValue(!doNotAskAgainCheckBox.isSelected());
        }
        return response;
    }

    public static File[] showCopyDialog(Component parent, File[] files, File target, BooleanSetting setting) {
        return Dialogs.showFilesActionDialog(parent, files, i18n.trn("Do you really want to copy the selected file to \"{0}\"?", "Do you really want to copy the selected files to \"{0}\"?", (long)files.length, target.getAbsolutePath()), i18n.tr("Copy Files"), setting);
    }

    public static File[] showDeleteDialog(Component parent, File[] files, BooleanSetting setting) {
        return Dialogs.showFilesActionDialog(parent, files, i18n.tr("Do you really want to delete the selected files?"), i18n.tr("Delete Files"), setting);
    }

    public static void showError(Component parent, String message) {
        Dialogs.showError(parent, message, i18n.tr("Error"));
    }

    public static void showError(Component parent, String message, Exception e) {
        Dialogs.showError(parent, message, i18n.tr("Error"), e);
    }

    public static void showError(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public static void showError(Component parent, String message, String title, Exception exception) {
        ErrorDialog.show(parent, message, title, exception);
    }

    public static File[] showFilesActionDialog(Component parent, File[] files, String message, String title, BooleanSetting setting) {
        if (setting != null && !((Boolean)setting.getValue()).booleanValue()) {
            return files;
        }
        JList<File> fileList = new JList<File>(files);
        fileList.setCellRenderer(new FileListCellRenderer());
        fileList.setVisibleRowCount(4);
        fileList.setSelectionInterval(0, files.length - 1);
        JCheckBox doNotAskAgainCheckBox = new JCheckBox(i18n.tr("Do not ask again"));
        Object[] content = new Object[]{message, Box.createVerticalStrut(10), new JScrollPane(fileList), Box.createVerticalStrut(10), doNotAskAgainCheckBox, Box.createVerticalStrut(5)};
        int response = JOptionPane.showConfirmDialog(parent, content, title, 0);
        if (setting != null) {
            setting.setValue(!doNotAskAgainCheckBox.isSelected());
        }
        if (response == 0) {
            Object[] rows = fileList.getSelectedValues();
            File[] selected = new File[rows.length];
            System.arraycopy(rows, 0, selected, 0, selected.length);
            return selected;
        }
        return new File[0];
    }

    public static void showInfo(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static File[] showMoveDialog(Component parent, File[] files, File target, BooleanSetting setting) {
        return Dialogs.showFilesActionDialog(parent, files, i18n.tr("Do you really want to move the selected files to \"{0}\"?", target.getAbsolutePath()), i18n.tr("Move Files"), setting);
    }

    public static class FileListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof File) {
                this.setText(((File)value).getName());
            }
            return this;
        }
    }
}

