/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.WhatsThis;
import org.xnap.commons.gui.util.WhatsThisAction;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.util.SystemHelper;

public class DefaultDialog
extends JDialog {
    private static final I18n i18n = I18nFactory.getI18n(DefaultDialog.class);
    public static int BUTTON_NONE = 0;
    public static int BUTTON_OKAY = 1;
    public static int BUTTON_APPLY = 2;
    public static int BUTTON_CANCEL = 4;
    public static int BUTTON_CLOSE = 8;
    public static int BUTTON_HELP = 16;
    public static int BUTTON_CONTEXT_HELP = 32;
    public static int BUTTON_DEFAULTS = 64;
    private ApplyAction applyAction = new ApplyAction();
    private CancelAction cancelAction = new CancelAction();
    private CloseAction closeAction = new CloseAction();
    private OkayAction okayAction = new OkayAction();
    private HelpAction helpAction = new HelpAction();
    private DefaultsAction defaultsAction = new DefaultsAction();
    private ContextHelpAction contextHelpAction = new ContextHelpAction();
    private JPanel buttonsLeftPanel;
    private JPanel buttonsRightPanel;
    private JPanel mainPanel;
    private JPanel topPanel;
    protected boolean isOkay = false;
    private JPanel bottomPanel;
    private JSeparator buttonSeparator;
    static /* synthetic */ Class class$0;

    public DefaultDialog(Dialog owner, int buttons, JComponent mainComponent) {
        super(owner);
        this.initialize(buttons, mainComponent);
    }

    public DefaultDialog(Frame owner, int buttons, JComponent mainComponent) {
        super(owner);
        this.initialize(buttons, mainComponent);
    }

    public DefaultDialog(int buttons, JComponent mainComponent) {
        this.initialize(buttons, mainComponent);
    }

    public DefaultDialog(Dialog owner, int buttons) {
        this(owner, buttons, null);
    }

    public DefaultDialog(Frame owner, int buttons) {
        this(owner, buttons, null);
    }

    public DefaultDialog(int buttons) {
        this(buttons, null);
    }

    public DefaultDialog(Dialog owner) {
        this(owner, BUTTON_OKAY | BUTTON_CANCEL);
    }

    public DefaultDialog(Frame owner) {
        this(owner, BUTTON_OKAY | BUTTON_CANCEL);
    }

    public DefaultDialog() {
        this(BUTTON_OKAY | BUTTON_CANCEL);
    }

    private void initialize(int buttons, JComponent mainComponent) {
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mainPanel = new JPanel();
        this.topPanel.add((Component)this.mainPanel, "Center");
        if (mainComponent != null) {
            this.setMainComponent(mainComponent);
        }
        this.buttonsLeftPanel = new JPanel(new FlowLayout(0));
        if ((buttons & BUTTON_HELP) > 0) {
            this.buttonsLeftPanel.add(new JButton(this.helpAction));
        }
        if ((buttons & BUTTON_CONTEXT_HELP) > 0) {
            this.buttonsLeftPanel.add(new JButton(this.contextHelpAction));
        }
        this.buttonsRightPanel = new JPanel(new FlowLayout(2));
        if ((buttons & BUTTON_OKAY) > 0) {
            JButton jbOkay = new JButton(this.okayAction);
            this.buttonsRightPanel.add(jbOkay);
        }
        if ((buttons & BUTTON_CLOSE) > 0) {
            this.buttonsRightPanel.add(new JButton(this.closeAction));
        }
        if ((buttons & BUTTON_DEFAULTS) > 0) {
            this.buttonsRightPanel.add(new JButton(this.defaultsAction));
        }
        if ((buttons & BUTTON_APPLY) > 0) {
            this.buttonsRightPanel.add(new JButton(this.applyAction));
        }
        if ((buttons & BUTTON_CANCEL) > 0) {
            JButton jbCancel = new JButton(this.cancelAction);
            GUIHelper.bindEscapeKey(this.topPanel, jbCancel.getAction());
            this.buttonsRightPanel.add(jbCancel);
        }
        if (SystemHelper.IS_MACOSX) {
            this.buttonsRightPanel.add(Box.createHorizontalStrut(15));
        }
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.bottomPanel.add((Component)this.buttonsLeftPanel, "West");
        this.bottomPanel.add((Component)this.buttonsRightPanel, "East");
        this.topPanel.add((Component)this.bottomPanel, "South");
        this.setButtonSeparatorVisible(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseListener());
        if (mainComponent != null) {
            this.pack();
        }
    }

    public boolean apply() {
        return true;
    }

    protected void cancelled() {
    }

    protected void defaults() {
    }

    public void close() {
        this.dispose();
    }

    public JPanel getButtonPanel() {
        return this.buttonsRightPanel;
    }

    public Action getApplyAction() {
        return this.applyAction;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public Action getDefaultsAction() {
        return this.defaultsAction;
    }

    public Action getOkayAction() {
        return this.okayAction;
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public Action getContextHelpAction() {
        return this.contextHelpAction;
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void contextHelp() {
        WhatsThis.enterWhatsThisMode();
    }

    public void help() {
    }

    public void setApplyOnEnter(boolean apply) {
        if (apply) {
            GUIHelper.bindEnterKey(this.topPanel, this.getOkayAction());
        } else {
            this.topPanel.getActionMap().remove(this.getOkayAction());
        }
    }

    public void setMainComponent(Component component) {
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add(component, "Center");
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    public void setButtonSeparatorVisible(boolean visible) {
        if (visible) {
            if (this.buttonSeparator == null) {
                this.buttonSeparator = new JSeparator();
                this.bottomPanel.add((Component)this.buttonSeparator, "North");
            }
        } else if (this.buttonSeparator != null) {
            this.bottomPanel.remove(this.buttonSeparator);
            this.buttonSeparator = null;
        }
    }

    public boolean isOkay() {
        return this.isOkay;
    }

    public void show(Component c) {
        if (!this.isVisible()) {
            if (c != null) {
                this.setLocationRelativeTo(c);
            }
            this.setVisible(true);
        } else {
            this.toFront();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            this.putValue("Name", i18n.tr("Apply"));
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.apply();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", i18n.tr("Cancel"));
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.isOkay = false;
            DefaultDialog.this.cancelled();
            DefaultDialog.this.close();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", i18n.tr("Close"));
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.isOkay = false;
            DefaultDialog.this.close();
        }
    }

    private class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", i18n.tr("Help"));
            this.putValue("MnemonicKey", new Integer(72));
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.help();
        }
    }

    private class DefaultsAction
    extends AbstractAction {
        public DefaultsAction() {
            this.putValue("Name", i18n.tr("Defaults"));
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.defaults();
        }
    }

    private class ContextHelpAction
    extends WhatsThisAction {
        ContextHelpAction() {
        }

        public void actionPerformed(ActionEvent event) {
            DefaultDialog.this.contextHelp();
        }
    }

    private class OkayAction
    extends AbstractAction {
        public OkayAction() {
            this.putValue("Name", i18n.tr("OK"));
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent event) {
            if (!DefaultDialog.this.apply()) {
                return;
            }
            DefaultDialog.this.isOkay = true;
            DefaultDialog.this.close();
        }
    }

    private class CloseListener
    extends WindowAdapter {
        CloseListener() {
        }

        public void windowClosing(WindowEvent evt) {
            DefaultDialog.this.isOkay = false;
            DefaultDialog.this.close();
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent event) {
            Dimension minimumSize = DefaultDialog.this.getMinimumSize();
            if (minimumSize == null || minimumSize.width <= DefaultDialog.this.getWidth() && minimumSize.height <= DefaultDialog.this.getHeight()) {
                return;
            }
            Dimension newSize = DefaultDialog.this.getSize();
            if (DefaultDialog.this.getWidth() < minimumSize.width) {
                newSize.width = minimumSize.width;
            }
            if (DefaultDialog.this.getHeight() < minimumSize.height) {
                newSize.height = minimumSize.height;
            }
            DefaultDialog.this.setSize(newSize);
        }
    }
}

