/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ColoredTable
extends JTable {
    private Color oddColor;
    private Color evenColor;

    public ColoredTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.updateColors();
    }

    public ColoredTable(TableModel dm) {
        super(dm);
        this.updateColors();
    }

    public ColoredTable() {
        this.updateColors();
    }

    public Color getBackgroundColor(int row) {
        return row % 2 == 1 ? this.oddColor : this.evenColor;
    }

    private void updateColors() {
        this.evenColor = UIManager.getColor("Table.background");
        this.oddColor = this.evenColor != null ? new Color(Math.max((int)((double)this.evenColor.getRed() * 0.9), 0), Math.max((int)((double)this.evenColor.getGreen() * 0.9), 0), Math.max((int)((double)this.evenColor.getBlue() * 0.9), 0)) : null;
    }

    public void updateUI() {
        super.updateUI();
        this.updateColors();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean hasFocus;
        Component c = super.prepareRenderer(renderer, row, column);
        boolean isSelected = this.isCellSelected(row, column);
        boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
        boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
        boolean bl = hasFocus = rowIsAnchor && colIsAnchor && this.hasFocus();
        if (!isSelected && !hasFocus) {
            c.setBackground(this.getBackgroundColor(row));
        }
        return c;
    }
}

