/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ColorChooserPanel
extends JPanel {
    private static final I18n i18n = I18nFactory.getI18n(ColorChooserPanel.class);
    private Color customColor = new Color(254, 254, 254);
    private JComboBox colorComboBox;
    private Map<Color, String> namesByColor = new Hashtable<Color, String>();
    private ColorChooserAction colorAction;
    private Component dialogParent;
    static /* synthetic */ Class class$0;

    public ColorChooserPanel(Color selectedColor) {
        this.initialize();
        this.setSelectedColor(selectedColor);
    }

    public ColorChooserPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 2));
        this.colorComboBox = new JComboBox();
        this.colorComboBox.setRenderer(new ColorCellRenderer());
        this.add(this.colorComboBox);
        this.add(Box.createHorizontalStrut(4));
        this.namesByColor.put(Color.black, i18n.tr("Black"));
        this.namesByColor.put(Color.darkGray, i18n.tr("DarkGray"));
        this.namesByColor.put(Color.gray, i18n.tr("Gray"));
        this.namesByColor.put(Color.lightGray, i18n.tr("LightGray"));
        this.namesByColor.put(Color.blue, i18n.tr("Blue"));
        this.namesByColor.put(Color.cyan, i18n.tr("Cyan"));
        this.namesByColor.put(Color.magenta, i18n.tr("Magenta"));
        this.namesByColor.put(Color.pink, i18n.tr("Pink"));
        this.namesByColor.put(Color.red, i18n.tr("Red"));
        this.namesByColor.put(Color.orange, i18n.tr("Orange"));
        this.namesByColor.put(Color.green, i18n.tr("Green"));
        this.namesByColor.put(Color.yellow, i18n.tr("Yellow"));
        this.namesByColor.put(Color.white, i18n.tr("White"));
        for (Color color : this.namesByColor.keySet()) {
            this.colorComboBox.addItem(color);
        }
        this.colorComboBox.addItem(this.customColor);
        this.colorAction = new ColorChooserAction();
        this.add(Builder.createIconButton(this.colorAction));
    }

    public Color getSelectedColor() {
        return (Color)this.colorComboBox.getSelectedItem();
    }

    public void setSelectedColor(Color newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (this.namesByColor.get(newValue) != null) {
            this.colorComboBox.setSelectedItem(newValue);
        } else {
            this.colorComboBox.removeItem(this.customColor);
            this.customColor = newValue;
            this.colorComboBox.addItem(this.customColor);
            this.colorComboBox.setSelectedItem(this.customColor);
        }
    }

    public Component getDialogParent() {
        return this.dialogParent;
    }

    public void setDialogParent(Component dialogParent) {
        this.dialogParent = dialogParent;
    }

    protected class ColorChooserAction
    extends AbstractXNapAction {
        public ColorChooserAction() {
            this.putValue("ShortDescription", i18n.tr("Opens color selection dialog"));
            this.putValue("XNapIcon", "palette_color.png");
        }

        public void actionPerformed(ActionEvent event) {
            Color c = JColorChooser.showDialog(ColorChooserPanel.this.getDialogParent(), i18n.tr("Choose color"), ColorChooserPanel.this.getSelectedColor());
            if (c != null) {
                ColorChooserPanel.this.setSelectedColor(c);
            }
        }
    }

    protected class ColorCellRenderer
    extends DefaultListCellRenderer {
        public ColorIcon icon;

        protected ColorCellRenderer() {
            this.icon = new ColorIcon(Color.white);
        }

        public Component getListCellRendererComponent(JList list, Object val, int idx, boolean isSel, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, val, idx, isSel, hasFocus);
            String colorName = (String)ColorChooserPanel.this.namesByColor.get(val);
            if (colorName == null) {
                colorName = i18n.tr("Custom");
            }
            this.setText(colorName);
            this.icon.setColor((Color)val);
            this.setIcon(this.icon);
            return this;
        }
    }

    protected class ColorIcon
    implements Icon {
        private int height = 15;
        private int width = 15;
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void setColor(Color newValue) {
            this.color = newValue;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.width, this.height);
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, this.width - 1, this.height - 1);
        }
    }
}

