/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xnap.commons.gui.ToolBarButton;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.util.IconHelper;

public class CloseableTabbedPane
extends JTabbedPane {
    private MouseHandler mouseHandler = new MouseHandler();
    private SelectionHandler selHandler = new SelectionHandler();
    private ComponentHandler compHandler = new ComponentHandler();
    private CloseListener closeListener = null;
    private boolean useScrollHack;

    public CloseableTabbedPane() {
        this.setTabLayoutPolicy(0);
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseListener(this.mouseHandler);
        this.getModel().addChangeListener(this.selHandler);
        this.addComponentListener(this.compHandler);
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    public void addTab(String title, Component component, Icon icon, boolean closeable) {
        if (closeable) {
            super.addTab(null, new TabTitleIcon(title, component, icon), component);
        } else {
            super.addTab(title, icon, component);
        }
        this.setSelectedComponent(component);
    }

    public void addTab(String title, Component component, Icon icon) {
        this.addTab(title, component, icon, true);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, component, null, true);
    }

    public void setTitleAt(int index, String newTitle) {
        Icon icon = this.getIconAt(index);
        if (icon instanceof TabTitleIcon) {
            TabTitleIcon tabIcon = (TabTitleIcon)icon;
            tabIcon.setTitle(newTitle);
            this.revalidate();
            this.repaint();
        } else {
            super.setTitleAt(index, newTitle);
        }
    }

    public String getTitleAt(int index) {
        return super.getTitleAt(index);
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
        this.useScrollHack = tabLayoutPolicy == 1;
        super.setTabLayoutPolicy(tabLayoutPolicy);
    }

    public void updateUI() {
        super.updateUI();
        int tabCount = this.getTabCount();
        int i = 0;
        while (i < tabCount) {
            Icon icon = this.getIconAt(i);
            if (icon instanceof TabTitleIcon) {
                ((TabTitleIcon)icon).updateUI();
            }
            ++i;
        }
    }

    private void setButtonVisible(int index, boolean visible) {
        Icon icon = this.getIconAt(index);
        if (icon instanceof TabTitleIcon) {
            ((TabTitleIcon)icon).setVisible(visible);
        }
    }

    public void removeTabAt(int index) {
        int sel;
        Icon icon = this.getIconAt(index);
        super.removeTabAt(index);
        if (icon instanceof TabTitleIcon) {
            ((TabTitleIcon)icon).disable();
        }
        if (this.mouseHandler.visibleIndex == index) {
            this.mouseHandler.visibleIndex = -1;
        }
        if (this.selHandler.oldIndex == index) {
            this.selHandler.oldIndex = -1;
        }
        if ((sel = this.getSelectedIndex()) != -1) {
            this.setButtonVisible(sel, true);
        }
    }

    public static interface CloseListener {
        public void closeRequested(Component var1);
    }

    private class DefaultCloseAction
    extends AbstractXNapAction {
        Component comp;

        public DefaultCloseAction(Component comp) {
            this.comp = comp;
            this.putValue("XNapIcon", "remove.png");
        }

        public void actionPerformed(ActionEvent e) {
            if (CloseableTabbedPane.this.closeListener != null) {
                CloseableTabbedPane.this.closeListener.closeRequested(this.comp);
            } else {
                CloseableTabbedPane.this.remove(this.comp);
            }
        }
    }

    protected class TabTitleIcon
    implements Icon {
        private Icon leftIcon;
        private EventIcon rightIcon;
        private String title;
        private int height = 10;

        public TabTitleIcon(String title, Component comp, Icon leftIcon) {
            this.title = title;
            this.leftIcon = leftIcon;
            this.rightIcon = new EventIcon(new TabTitleButton(new DefaultCloseAction(comp)));
            this.height = Math.max(this.rightIcon.getIconHeight(), leftIcon != null ? leftIcon.getIconHeight() : 0);
        }

        public void updateUI() {
            this.rightIcon.updateUI();
        }

        public TabTitleIcon(String title, Component comp) {
            this(title, comp, null);
        }

        public void setTitle(String newTitle) {
            this.title = newTitle;
        }

        public String getTitle() {
            return this.title;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            int textWidth = SwingUtilities.computeStringWidth(CloseableTabbedPane.this.getFontMetrics(CloseableTabbedPane.this.getFont()), this.title);
            if (this.leftIcon != null) {
                return this.leftIcon.getIconWidth() + this.rightIcon.getIconWidth() + textWidth + 16;
            }
            return textWidth + 8 + this.rightIcon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.leftIcon != null) {
                this.leftIcon.paintIcon(c, g, x, y + 1);
                this.drawTitleAndRightIcon(c, g, x, y, this.leftIcon.getIconWidth() + 8);
            } else {
                this.drawTitleAndRightIcon(c, g, x, y, 0);
            }
        }

        protected Rectangle computeTextRect(Graphics g, int x, int y) {
            Rectangle rect = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            SwingUtilities.layoutCompoundLabel(CloseableTabbedPane.this, g.getFontMetrics(), this.title, null, 0, 0, 0, 11, rect, iconRect, textRect, UIManager.getInt("TabbedPane.textIconGap"));
            return textRect;
        }

        protected void drawTitleAndRightIcon(Component c, Graphics g, int x, int y, int offset) {
            Rectangle textRect = this.computeTextRect(g, x, y);
            int index = CloseableTabbedPane.this.indexOfTab(this);
            g.setColor(index != -1 ? CloseableTabbedPane.this.getForegroundAt(index) : CloseableTabbedPane.this.getForegroundAt(index));
            g.setFont(CloseableTabbedPane.this.getFont());
            g.drawString(this.title, x + offset, textRect.y + g.getFontMetrics().getAscent());
            if (CloseableTabbedPane.this.useScrollHack) {
                if (index != -1) {
                    Rectangle bounds = CloseableTabbedPane.this.getUI().getTabBounds(CloseableTabbedPane.this, index);
                    Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
                    this.rightIcon.paintIcon(c, g, bounds.x + tabInsets.left + this.getIconWidth() + 3 - this.rightIcon.getIconWidth(), bounds.y + tabInsets.top + 1);
                } else {
                    this.rightIcon.paintIcon(c, g, x + this.getIconWidth() - this.rightIcon.getIconWidth(), y + 1);
                }
            } else {
                this.rightIcon.paintIcon(c, g, x + this.getIconWidth() - this.rightIcon.getIconWidth(), y + 1);
            }
        }

        public void setVisible(boolean b) {
            this.rightIcon.setVisible(b);
        }

        public void disable() {
            this.rightIcon.disable();
        }
    }

    private class EventIcon
    implements Icon {
        AbstractButton button;
        JLayeredPane pane;

        public EventIcon(AbstractButton button) {
            this.button = button;
            JRootPane rootPane = SwingUtilities.getRootPane(CloseableTabbedPane.this);
            if (rootPane != null) {
                this.pane = rootPane.getLayeredPane();
                this.pane.add((Component)button, JLayeredPane.PALETTE_LAYER);
            }
        }

        public void updateUI() {
            this.button.updateUI();
        }

        public void disable() {
            this.button.setVisible(false);
            this.button.setEnabled(false);
            this.pane.remove(this.button);
        }

        public void setVisible(boolean b) {
            this.button.setVisible(b);
        }

        public int getIconHeight() {
            return this.button.getPreferredSize().height;
        }

        public int getIconWidth() {
            return this.button.getPreferredSize().width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.pane == null) {
                JRootPane rootPane = SwingUtilities.getRootPane(CloseableTabbedPane.this);
                this.pane = rootPane.getLayeredPane();
                this.pane.add((Component)this.button, JLayeredPane.PALETTE_LAYER);
            }
            Point p = SwingUtilities.convertPoint(c, x, y, this.pane);
            this.button.setBounds(p.x, p.y, this.getIconHeight(), this.getIconWidth());
        }
    }

    private class TabTitleButton
    extends ToolBarButton {
        public TabTitleButton(Action action) {
            super(action);
            String iconName = (String)action.getValue("XNapIcon");
            this.setIcon(IconHelper.getTabTitleIcon(iconName));
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int visibleIndex = -1;

        MouseHandler() {
        }

        public void mouseEntered(MouseEvent event) {
            this.updateButton(event);
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
            this.updateButton(event);
        }

        public void mouseDragged(MouseEvent event) {
            this.updateButton(event);
        }

        private void updateButton(MouseEvent event) {
            int index = CloseableTabbedPane.this.getUI().tabForCoordinate(CloseableTabbedPane.this, event.getX(), event.getY());
            if (index != -1 && index != CloseableTabbedPane.this.getSelectedIndex()) {
                if (this.visibleIndex == index) {
                    return;
                }
                CloseableTabbedPane.this.setButtonVisible(index, true);
                if (this.visibleIndex != index && this.visibleIndex != -1 && this.visibleIndex != CloseableTabbedPane.this.getSelectedIndex()) {
                    CloseableTabbedPane.this.setButtonVisible(this.visibleIndex, false);
                }
                this.visibleIndex = index;
            } else if (this.visibleIndex != -1 && this.visibleIndex != CloseableTabbedPane.this.getSelectedIndex() && this.visibleIndex < CloseableTabbedPane.this.getTabCount()) {
                CloseableTabbedPane.this.setButtonVisible(this.visibleIndex, false);
                this.visibleIndex = -1;
            }
        }
    }

    private class SelectionHandler
    implements ChangeListener {
        int oldIndex = -1;

        SelectionHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            if (this.oldIndex != -1) {
                CloseableTabbedPane.this.setButtonVisible(this.oldIndex, false);
            }
            this.oldIndex = CloseableTabbedPane.this.getSelectedIndex();
            if (this.oldIndex != -1) {
                CloseableTabbedPane.this.setButtonVisible(this.oldIndex, true);
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentHidden(ComponentEvent e) {
            int sel = CloseableTabbedPane.this.getSelectedIndex();
            if (sel != -1) {
                CloseableTabbedPane.this.setButtonVisible(sel, false);
            }
        }

        public void componentShown(ComponentEvent e) {
            int sel = CloseableTabbedPane.this.getSelectedIndex();
            if (sel != -1) {
                CloseableTabbedPane.this.setButtonVisible(sel, true);
            }
        }
    }
}

