/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import org.xnap.commons.gui.action.ToggleAction;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.CompletionModel;
import org.xnap.commons.gui.factory.DefaultFactory;
import org.xnap.commons.gui.factory.Factory;

public class Builder {
    private static Factory factory = new DefaultFactory();

    public static void setFactory(Factory factory) {
        Builder.factory = factory == null ? new DefaultFactory() : factory;
    }

    public static Factory getFactory() {
        return factory;
    }

    public static Completion addCompletion(JTextComponent textComponent) {
        Completion completion = new Completion(textComponent);
        factory.addCompletionModeMenu(textComponent, completion);
        return completion;
    }

    public static Completion addCompletion(JTextComponent textComponent, CompletionModel model) {
        Completion completion = new Completion(textComponent, model);
        factory.addCompletionModeMenu(textComponent, completion);
        return completion;
    }

    public static Completion addCompletion(JTextComponent textComponent, JMenu menu) {
        Completion completion = new Completion(textComponent);
        factory.addCompletionModeMenu(menu, completion);
        return completion;
    }

    public static Completion addCompletion(JTextComponent textComponent, JMenu menu, CompletionModel model) {
        Completion completion = new Completion(textComponent, model);
        factory.addCompletionModeMenu(menu, completion);
        return completion;
    }

    public static AbstractButton createButton(Action action) {
        return factory.createButton(action);
    }

    public static AbstractButton createCheckBox(ToggleAction action) {
        return factory.createCheckBox(action);
    }

    public static AbstractButton createIconButton(Action action) {
        return factory.createIconButton(action);
    }

    public static AbstractButton createToolBarButton(Action action) {
        return factory.createToolBarButton(action);
    }

    public static JComponent createMenuItem(Action action) {
        return factory.createMenuItem(action);
    }

    public static void setProperty(Object key, Object value) {
        factory.setProperty(key, value);
    }
}

