/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.xnap.commons.gui.CloseableTabbedPane;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.i18n.I18nFactory;

public class AboutDialog
extends DefaultDialog {
    private CloseableTabbedPane tabbedPane;
    private Map<String, JComponent> tabByFilename = new Hashtable<String, JComponent>();
    static /* synthetic */ Class class$0;

    public AboutDialog(JDialog owner) {
        super((Dialog)owner, BUTTON_CLOSE);
        this.initialize();
    }

    public AboutDialog(JFrame owner) {
        super((Frame)owner, BUTTON_CLOSE);
        this.initialize();
    }

    public AboutDialog() {
        super(BUTTON_CLOSE);
        this.initialize();
    }

    private void initialize() {
        this.tabbedPane = new CloseableTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(600, 300));
        this.tabbedPane.setCloseListener(new CloseableTabbedPane.CloseListener(){

            public void closeRequested(Component component) {
                AboutDialog.this.tabbedPane.remove(component);
                AboutDialog.this.tabByFilename.values().remove(component);
            }
        });
        this.setMainComponent(this.tabbedPane);
        this.setButtonSeparatorVisible(false);
        this.pack();
    }

    public JTextArea addLogoTab(String title, Icon image, String filename, String alternativeMessage, boolean closeable) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new BorderLayout());
        JLabel logoLabel = new JLabel(image);
        logoLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)logoLabel, "North");
        JTextArea textArea = new JTextArea(5, 40);
        textArea.setEditable(false);
        textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)textArea, "Center");
        this.addTabInternal(textArea, title, filename, alternativeMessage, closeable);
        return textArea;
    }

    public JTextArea addLogoTab(String title, Icon image, String filename) {
        return this.addLogoTab(title, image, filename, this.getFileNotFoundMessage(filename), false);
    }

    public JTextArea addTab(String title, String filename, String alternativeMessage, boolean closeable) {
        JTextArea textArea = new JTextArea(15, 40);
        textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        textArea.setEditable(false);
        this.addTabInternal(textArea, title, filename, alternativeMessage, closeable);
        return textArea;
    }

    public JTextArea addTab(String title, String filename) {
        return this.addTab(title, filename, this.getFileNotFoundMessage(filename), false);
    }

    public JEditorPane addHTMLTab(String title, String filename, String alternativeMessage, boolean closeable, boolean followHyperlinks) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        if (followHyperlinks) {
            editorPane.addHyperlinkListener(new LicenseLinkListener());
        }
        editorPane.setBorder(GUIHelper.createEmptyBorder(5));
        this.addTabInternal(editorPane, title, filename, alternativeMessage, closeable);
        return editorPane;
    }

    public JEditorPane addHTMLTab(String title, String filename, boolean followHyperlinks) {
        return this.addHTMLTab(title, filename, this.getFileNotFoundMessage(filename), false, followHyperlinks);
    }

    private void addTabInternal(JTextComponent component, String title, String filename, String alternativeMessage, boolean closeable) {
        JScrollPane scrollPane = new JScrollPane(component);
        GUIHelper.showFile(component, filename, alternativeMessage);
        this.getTabbedPane().addTab(title, scrollPane, null, closeable);
        this.tabByFilename.put(filename, scrollPane);
    }

    public CloseableTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getFileNotFoundMessage(String filename) {
        return I18nFactory.getI18n(AboutDialog.class).tr("File {0} not found", filename);
    }

    public Component getOrAddTab(String name, String filename) {
        JComponent c = this.tabByFilename.get(filename);
        if (c == null) {
            if (filename.endsWith("html") || filename.endsWith("htm")) {
                this.addHTMLTab(name, filename, this.getFileNotFoundMessage(filename), true, false);
            } else {
                JTextArea textArea = this.addTab(name, filename, this.getFileNotFoundMessage(filename), true);
                textArea.setFont(new Font("Monospaced", 0, 10));
            }
            c = this.tabByFilename.get(filename);
        }
        return c;
    }

    private class LicenseLinkListener
    implements HyperlinkListener {
        LicenseLinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getDescription() == null) {
                return;
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                this.setCursor(event, Cursor.getPredefinedCursor(12));
            } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.setCursor(event, null);
            } else if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.setCursor(event, null);
                Component c = AboutDialog.this.getOrAddTab(event.getDescription(), event.getDescription());
                AboutDialog.this.tabbedPane.setSelectedComponent(c);
            }
        }

        private void setCursor(HyperlinkEvent event, Cursor cursor) {
            JEditorPane pane = (JEditorPane)event.getSource();
            AboutDialog.this.setCursor(cursor);
        }
    }
}

