/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.wimpi.pim.util.Base64;
import net.wimpi.pim.util.QuotedPrintable;

public class EncodingUtility {
    private static final byte[] NEWLINE_ENC = new byte[]{92, 110};

    public static byte[] decodeBase64(byte[] byArray) {
        return Base64.decode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return Base64.decode(string.getBytes());
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encode(byArray);
    }

    public static String decodeQP(String string) {
        return QuotedPrintable.decode(string);
    }

    public static String encodeQP(String string) {
        return QuotedPrintable.encode(string);
    }

    public static byte[] removeWhiteSpace(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 9 || byArray[i] == 32) continue;
            byteArrayOutputStream.write(byArray[i]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static InputStream removeWhiteSpace(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        int n = 0;
        while (n != -1) {
            n = inputStream.read();
            if (n == -1 || n == 10 || n == 13 || n == 9 || n == 32) continue;
            byteArrayOutputStream.write(n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static byte[] encodeLineBreaks(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 13 && byArray[i + 1] == 10) {
                    byteArrayOutputStream.write(NEWLINE_ENC);
                    ++i;
                    continue;
                }
                if (byArray[i] == 13) {
                    byteArrayOutputStream.write(NEWLINE_ENC);
                    continue;
                }
                if (byArray[i] == 10) {
                    byteArrayOutputStream.write(NEWLINE_ENC);
                    continue;
                }
                byteArrayOutputStream.write(byArray[i]);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return byArray;
        }
    }

    public static String encodeLineBreaks(String string) {
        return new String(EncodingUtility.encodeLineBreaks(string.getBytes()));
    }

    public static InputStream encodeLineBreaks(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        int n = 0;
        while (n != -1) {
            n = inputStream.read();
            if (n == -1) continue;
            if (n == 13) {
                n = inputStream.read();
                if (n == 10) {
                    byteArrayOutputStream.write(NEWLINE_ENC);
                    continue;
                }
                byteArrayOutputStream.write(NEWLINE_ENC);
                byteArrayOutputStream.write(n);
                continue;
            }
            if (n == 10) {
                byteArrayOutputStream.write(NEWLINE_ENC);
                continue;
            }
            byteArrayOutputStream.write(n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

